/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.trees.dhtpn.SerializableDoubleHierarchicalTypedProperties;
import com.davidsoergel.trees.htpn.HierarchicalTypedPropertyNode;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import edu.berkeley.compbio.ml.cluster.DistanceBasedMultiClassCrossValidationResults;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringTestResults<L extends Comparable> {
    private List<Double> computedDistances = new ArrayList<Double>();
    private List<Double> secondToBestDistanceRatios = new ArrayList<Double>();
    private final List<Double> bestVoteProportions = new ArrayList<Double>();
    private List<Double> secondToBestVoteRatios = new ArrayList<Double>();
    private int unknown = 0;
    private int numClusters = 0;
    private int testSamples;
    private double trainingSeconds;
    private double testingSeconds;
    private double totalTrainingMass = 0.0;
    private String info;
    private Map<L, String> friendlyLabelMap;
    private final Map<String, DistanceBasedMultiClassCrossValidationResults<L>> cvResultMap = new MapMaker().makeComputingMap(new Function<String, DistanceBasedMultiClassCrossValidationResults<L>>(){

        @Override
        public DistanceBasedMultiClassCrossValidationResults apply(@Nullable String from) {
            return new DistanceBasedMultiClassCrossValidationResults();
        }
    });

    public void setFriendlyLabelMap(Map<L, String> friendlyLabelMap) {
        this.friendlyLabelMap = friendlyLabelMap;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public synchronized int getNumClusters() {
        return this.numClusters;
    }

    public synchronized void setNumClusters(int numClusters) {
        this.numClusters = numClusters;
    }

    public synchronized int getTestSamples() {
        return this.testSamples;
    }

    public synchronized void setTestSamples(int i) {
        this.testSamples = i;
    }

    public double getTestingSeconds() {
        return this.testingSeconds;
    }

    public void setTestingSeconds(double testingSeconds) {
        this.testingSeconds = testingSeconds;
    }

    public double getTotalTrainingMass() {
        return this.totalTrainingMass;
    }

    public double getTrainingSeconds() {
        return this.trainingSeconds;
    }

    public void setTrainingSeconds(double trainingSeconds) {
        this.trainingSeconds = trainingSeconds;
    }

    public int getUnknown() {
        return this.unknown;
    }

    public synchronized void addClusterResult(double bestDistance, double secondToBestDistanceRatio, double bestVoteProportion, double secondToBestVoteRatio) {
        assert (!Double.isNaN(bestDistance) && !Double.isInfinite(bestDistance));
        assert (!Double.isNaN(secondToBestDistanceRatio) && !Double.isInfinite(secondToBestDistanceRatio));
        assert (!Double.isNaN(secondToBestVoteRatio) && !Double.isInfinite(secondToBestVoteRatio));
        this.computedDistances.add(bestDistance);
        this.secondToBestDistanceRatios.add(secondToBestDistanceRatio);
        this.bestVoteProportions.add(bestVoteProportion);
        this.secondToBestVoteRatios.add(secondToBestVoteRatio);
    }

    public synchronized void addPredictionResult(String predictionSetName, String broadActualLabel, String predictedLabel, double clusterProb, double broadWrongness, double detailedWrongness) {
        assert (!Double.isNaN(broadWrongness) && !Double.isInfinite(broadWrongness));
        assert (!Double.isNaN(detailedWrongness) && !Double.isInfinite(detailedWrongness));
        assert (!Double.isNaN(clusterProb) && !Double.isInfinite(clusterProb));
        DistanceBasedMultiClassCrossValidationResults<String> cvResults = this.cvResultMap.get(predictionSetName);
        cvResults.addSample(broadActualLabel, predictedLabel, clusterProb, broadWrongness, detailedWrongness);
    }

    public synchronized void finish() {
        if (DSCollectionUtils.allElementsNaN(this.computedDistances)) {
            this.computedDistances = null;
        }
        if (DSCollectionUtils.allElementsEqual(this.secondToBestDistanceRatios, 0.0)) {
            this.secondToBestDistanceRatios = null;
        }
        if (DSCollectionUtils.allElementsEqual(this.secondToBestVoteRatios, 0.0)) {
            this.secondToBestVoteRatios = null;
        }
        if (DSCollectionUtils.allElementsEqual(this.computedDistances, 1.0)) {
            this.computedDistances = null;
        }
        for (DistanceBasedMultiClassCrossValidationResults<L> cvResults : this.cvResultMap.values()) {
            cvResults.finish();
        }
    }

    public synchronized Double[] getBestVoteProportionsArray() {
        return this.bestVoteProportions == null ? null : this.bestVoteProportions.toArray(DSArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY);
    }

    public synchronized Double[] getComputedDistancesArray() {
        return this.computedDistances == null ? null : this.computedDistances.toArray(DSArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY);
    }

    public synchronized Double[] getSecondToBestDistanceRatiosArray() {
        return this.secondToBestDistanceRatios == null ? null : this.secondToBestDistanceRatios.toArray(DSArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY);
    }

    public synchronized Double[] getSecondToBestVoteRatiosArray() {
        return this.secondToBestVoteRatios == null ? null : this.secondToBestVoteRatios.toArray(DSArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY);
    }

    public synchronized void incrementShouldHaveBeenUnknown(String predictionSetName) {
        DistanceBasedMultiClassCrossValidationResults<L> cvResults = this.cvResultMap.get(predictionSetName);
        cvResults.incrementShouldHaveBeenUnknown();
    }

    public synchronized void incrementShouldNotHaveBeenUnknown(String predictionSetName) {
        DistanceBasedMultiClassCrossValidationResults<L> cvResults = this.cvResultMap.get(predictionSetName);
        cvResults.incrementShouldNotHaveBeenUnknown();
    }

    public synchronized void incrementOther(String predictionSetName) {
        DistanceBasedMultiClassCrossValidationResults<L> cvResults = this.cvResultMap.get(predictionSetName);
        cvResults.incrementOther();
    }

    public synchronized void incrementShouldNotHaveBeenOther(String predictionSetName) {
        DistanceBasedMultiClassCrossValidationResults<L> cvResults = this.cvResultMap.get(predictionSetName);
        cvResults.incrementShouldNotHaveBeenOther();
    }

    public synchronized void incrementTotalTrainingMass(double weightSum) {
        this.totalTrainingMass += weightSum;
    }

    public synchronized void incrementUnknown() {
        ++this.unknown;
    }

    public void putResults(SerializableDoubleHierarchicalTypedProperties<?> outerResults, String labelDistancesName) {
        HierarchicalTypedPropertyNode innerResults = (HierarchicalTypedPropertyNode)outerResults.getPayload();
        innerResults.addChild("numClusters", Integer.valueOf(this.getNumClusters()));
        innerResults.addChild("computedDistances", this.getComputedDistancesArray());
        innerResults.addChild("secondToBestDistanceRatios", this.getSecondToBestDistanceRatiosArray());
        innerResults.addChild("voteProportions", this.getBestVoteProportionsArray());
        innerResults.addChild("secondToBestVoteRatios", this.getSecondToBestVoteRatiosArray());
        innerResults.addChild("trainingSeconds", Double.valueOf(this.getTrainingSeconds()));
        innerResults.addChild("testingSecondsPerSample", Double.valueOf(this.getTestingSeconds() / (double)this.getTestSamples()));
        innerResults.addChild("unknownCluster", Integer.valueOf(this.getUnknown()));
        innerResults.addChild("totalTrainingMass", Double.valueOf(this.getTotalTrainingMass()));
        innerResults.addChild("modelInfo", this.getInfo());
        for (Map.Entry<String, DistanceBasedMultiClassCrossValidationResults<L>> entry : this.cvResultMap.entrySet()) {
            String predictionLabelsName = entry.getKey();
            SerializableDoubleHierarchicalTypedProperties childResults = (SerializableDoubleHierarchicalTypedProperties)outerResults.newChild(outerResults.newPayload());
            childResults.setId2(predictionLabelsName);
            HierarchicalTypedPropertyNode childResultsNode = (HierarchicalTypedPropertyNode)childResults.getPayload();
            try {
                childResultsNode.addChild("predictionLabelSet", new Double(predictionLabelsName));
            }
            catch (NumberFormatException e) {
                childResultsNode.addChild("predictionLabelSet", predictionLabelsName);
            }
            entry.getValue().putResults(childResultsNode, labelDistancesName, this.friendlyLabelMap);
        }
    }
}

