/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.dsutils.math.MathUtils;
import com.davidsoergel.stats.DissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CentroidClusteringUtils {
    private static final Logger logger = Logger.getLogger(CentroidClusteringUtils.class);

    public static <T extends Clusterable<T>> void computeClusterStdDevs(Collection<? extends CentroidCluster<T>> theClusters, DissimilarityMeasure<T> measure, Map<String, ? extends CentroidCluster<T>> assignments, ClusterableIterator<T> theDataPointProvider) {
        for (CentroidCluster<T> c : theClusters) {
            c.setSumOfSquareDistances(0.0);
        }
        try {
            while (true) {
                CentroidCluster<T> c;
                T p = theDataPointProvider.nextFullyLabelled();
                c = assignments.get(p.getId());
                double dist = measure.distanceFromTo(p, c.getCentroid());
                c.addToSumOfSquareDistances(dist * dist);
            }
        }
        catch (NoSuchElementException e) {
            return;
        }
    }

    public static <T extends Clusterable<T>> String shortClusteringStats(Collection<? extends CentroidCluster<T>> theClusters, DissimilarityMeasure<T> measure) {
        ArrayList<Double> distances = new ArrayList<Double>();
        boolean numDistances = false;
        for (CentroidCluster<T> c : theClusters) {
            for (CentroidCluster<T> d : theClusters) {
                double distance = measure.distanceFromTo(c.getCentroid(), d.getCentroid());
                if (c == d && !MathUtils.equalWithinFPError(distance, 0.0)) {
                    logger.warn("Floating point trouble: self distance = " + distance + " " + c);
                    assert (false);
                }
                if (c == d) continue;
                logger.debug("Distance between clusters = " + d);
                distances.add(distance);
            }
        }
        double avg = DSCollectionUtils.sum(distances) / (double)distances.size();
        double sd = 0.0;
        Iterator i$ = distances.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            sd += d * d;
        }
        sd = Math.sqrt(sd / (double)distances.size());
        return new Formatter().format("Separation: %.3f (%.3f)", avg, sd).toString();
    }

    public static <T extends Clusterable<T>> void writeClusteringStatsToStream(Collection<? extends CentroidCluster<T>> theClusters, DissimilarityMeasure<T> measure, OutputStream outf) {
        PrintWriter p = new PrintWriter(outf);
        for (CentroidCluster<T> c : theClusters) {
            p.println(c);
            double stddev1 = c.getStdDev();
            for (CentroidCluster<T> d : theClusters) {
                double distance = measure.distanceFromTo(c.getCentroid(), d.getCentroid());
                if (c == d && !MathUtils.equalWithinFPError(distance, 0.0)) {
                    logger.warn("Floating point trouble: self distance = " + distance + " " + c);
                    assert (false);
                }
                double stddev2 = d.getStdDev();
                double margin1 = distance - (stddev1 + stddev2);
                double margin2 = distance - 2.0 * (stddev1 + stddev2);
                p.printf("\t%.2f (%.2f)", distance, margin1);
            }
            p.println();
        }
        p.flush();
    }
}

