/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import edu.berkeley.compbio.ml.cluster.AbstractCluster;
import edu.berkeley.compbio.ml.cluster.Cluster;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchCluster<T extends Clusterable<T>>
extends AbstractCluster<T>
implements Comparable<BatchCluster<T>> {
    private Set<T> thePoints = new HashSet<T>();

    public BatchCluster(int id) {
        super(id);
    }

    public synchronized String toString() {
        return "BatchCluster containing " + this.thePoints.size() + " points";
    }

    @Override
    public synchronized boolean add(T point2) {
        if (this.thePoints.add(point2)) {
            super.add(point2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addAll(Cluster<T> otherCluster) {
        if (this.thePoints.addAll(((BatchCluster)otherCluster).getPoints())) {
            super.addAll(otherCluster);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(T point2) {
        if (this.thePoints.remove(point2)) {
            super.remove(point2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll(Cluster<T> otherCluster) {
        if (this.thePoints.removeAll(((BatchCluster)otherCluster).getPoints())) {
            super.removeAll(otherCluster);
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(BatchCluster<T> o) {
        return this.id - o.getId();
    }

    public synchronized void forgetExamples() {
        this.thePoints = new HashSet<T>();
    }

    public synchronized Set<T> getPoints() {
        return this.thePoints;
    }
}

