/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.stats.DistributionException;
import com.davidsoergel.stats.Multinomial;
import com.google.common.collect.ImmutableMap;
import edu.berkeley.compbio.ml.cluster.AbstractClusteringMethod;
import edu.berkeley.compbio.ml.cluster.Cluster;
import edu.berkeley.compbio.ml.cluster.ClusterRuntimeException;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.OnlineClusteringMethod;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.SupervisedClusteringMethod;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSupervisedOnlineClusteringMethod<T extends Clusterable<T>, C extends Cluster<T>>
extends AbstractClusteringMethod<T, C>
implements OnlineClusteringMethod<T>,
SupervisedClusteringMethod<T> {
    private static final Logger logger = Logger.getLogger(AbstractSupervisedOnlineClusteringMethod.class);
    protected Map<Cluster<T>, Double> clusterPriors;

    protected AbstractSupervisedOnlineClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
    }

    public synchronized void train(ClusterableIterator<T> trainingIterator) {
        this.trainWithKnownTrainingLabels(trainingIterator);
        this.removeEmptyClusters();
        this.normalizeClusterLabelProbabilities();
        this.preparePriors();
    }

    protected abstract void trainWithKnownTrainingLabels(ClusterableIterator<T> var1);

    protected synchronized void preparePriors() {
        try {
            Multinomial<Cluster> priorsMult = new Multinomial<Cluster>();
            for (Cluster cluster : this.getClusters()) {
                priorsMult.put(cluster, 1.0);
            }
            priorsMult.normalize();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.clusterPriors = builder.putAll(priorsMult.getValueMap()).build();
        }
        catch (DistributionException e) {
            logger.error("Error", e);
            throw new ClusterRuntimeException(e);
        }
    }
}

