/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import com.davidsoergel.conja.Function;
import com.davidsoergel.conja.Parallel;
import com.davidsoergel.conja.ProgressReportingThreadPoolExecutor;
import com.davidsoergel.dsutils.collections.WeightedSet;
import com.davidsoergel.dsutils.math.MersenneTwisterFast;
import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.stats.DistributionException;
import com.davidsoergel.stats.RequiresPreparationDistanceMetric;
import edu.berkeley.compbio.ml.cluster.Cluster;
import edu.berkeley.compbio.ml.cluster.ClusterException;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.ClusteringMethod;
import edu.berkeley.compbio.ml.cluster.ClusteringTestResults;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClusteringMethod<T extends Clusterable<T>, C extends Cluster<T>>
implements ClusteringMethod<T> {
    private static final Logger logger = Logger.getLogger(AbstractClusteringMethod.class);
    protected final DissimilarityMeasure<T> measure;
    protected final Set<String> potentialTrainingBins;
    protected final Map<String, Set<String>> predictLabelSets;
    protected final ProhibitionModel<T> prohibitionModel;
    protected final Set<String> testLabels;
    protected final ArrayList<C> theClusters;
    protected final Map<String, C> assignments;
    protected int n;

    public String getDistanceSpec() {
        return ((Object)this.measure).toString();
    }

    public void setN(int n) {
        this.n = n;
    }

    public AbstractClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels) {
        this.measure = dm;
        this.potentialTrainingBins = potentialTrainingBins;
        this.prohibitionModel = prohibitionModel;
        this.predictLabelSets = predictLabelSets;
        this.testLabels = testLabels;
        this.theClusters = new ArrayList();
        this.assignments = new HashMap<String, C>();
        this.n = 0;
    }

    public AbstractClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels, ArrayList<C> theClusters, Map<String, C> assignments, int n) {
        this.measure = dm;
        this.potentialTrainingBins = potentialTrainingBins;
        this.prohibitionModel = prohibitionModel;
        this.predictLabelSets = predictLabelSets;
        this.testLabels = testLabels;
        this.theClusters = theClusters;
        this.assignments = assignments;
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumClusters() {
        ArrayList<C> arrayList = this.theClusters;
        synchronized (arrayList) {
            return this.theClusters.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<C> getClusters() {
        ArrayList<C> arrayList = this.theClusters;
        synchronized (arrayList) {
            return Collections.unmodifiableList(this.theClusters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumClusters(int numClusters) {
        ArrayList<C> arrayList = this.theClusters;
        synchronized (arrayList) {
            this.theClusters.ensureCapacity(numClusters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCluster(C c) {
        ArrayList<C> arrayList = this.theClusters;
        synchronized (arrayList) {
            this.theClusters.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCluster(int index, C c) {
        ArrayList<C> arrayList = this.theClusters;
        synchronized (arrayList) {
            this.theClusters.set(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterIndexOf(C c) {
        ArrayList<C> arrayList = this.theClusters;
        synchronized (arrayList) {
            return this.theClusters.indexOf(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getCluster(int index) {
        ArrayList<C> arrayList = this.theClusters;
        synchronized (arrayList) {
            return (C)((Cluster)this.theClusters.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, C> getAssignments() {
        Map<String, C> map = this.assignments;
        synchronized (map) {
            return Collections.unmodifiableMap(this.assignments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAssignment(String pointId, C cluster) {
        Map<String, C> map = this.assignments;
        synchronized (map) {
            this.assignments.put(pointId, cluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEmptyClusters() {
        ArrayList<C> arrayList = this.theClusters;
        synchronized (arrayList) {
            Iterator<C> iter = this.theClusters.iterator();
            while (iter.hasNext()) {
                Cluster c = (Cluster)iter.next();
                if (c.getN() != 0) continue;
                iter.remove();
            }
        }
    }

    @Override
    public synchronized ClusteringTestResults test(ClusterableIterator<T> theTestIterator, final DissimilarityMeasure<String> intraLabelDistances) throws DistributionException, ClusterException {
        final ClusteringTestResults tr = new ClusteringTestResults();
        tr.setNumClusters(this.getNumClusters());
        this.computeTrainingMass(tr);
        if (intraLabelDistances instanceof RequiresPreparationDistanceMetric && ((RequiresPreparationDistanceMetric)((Object)intraLabelDistances)).reallyRequiresPreparation()) {
            HashSet<String> allLabels = new HashSet<String>();
            allLabels.addAll(this.testLabels);
            for (Set<String> predictLabels : this.predictLabelSets.values()) {
                allLabels.addAll(predictLabels);
            }
            ((RequiresPreparationDistanceMetric)((Object)intraLabelDistances)).prepare(allLabels);
        }
        final Map<String, Set<String>> populatedPredictLabelSets = this.findPopulatedPredictLabelSets();
        final AtomicInteger i = new AtomicInteger(0);
        Parallel.forEach(theTestIterator, new Function<T, Void>(){

            @Override
            public Void apply(@Nullable T frag) {
                frag.doneLabelling();
                i.incrementAndGet();
                AbstractClusteringMethod.this.testOneSample(intraLabelDistances, tr, populatedPredictLabelSets, frag);
                return null;
            }
        });
        logger.info("Tested " + i + " samples.");
        tr.setTestSamples(i.intValue());
        tr.finish();
        return tr;
    }

    @Override
    public String bestLabel(T sample, Set<String> predictLabels) throws NoGoodClusterException {
        Object c = this.bestClusterMove(sample).bestCluster;
        return c.getImmutableWeightedLabels().getDominantKeyInSet(predictLabels);
    }

    protected Cluster<T> chooseRandomCluster() {
        return this.getCluster(MersenneTwisterFast.randomInt(this.getNumClusters()));
    }

    public String clusteringStats() {
        return "No clustering stats available";
    }

    protected Map<String, Set<String>> findPopulatedPredictLabelSets() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : this.predictLabelSets.entrySet()) {
            String predictionSetName = entry.getKey();
            Set<String> predictLabels = entry.getValue();
            HashSet<String> populatedPredictLabels = new HashSet<String>();
            int clustersWithPredictionLabel = 0;
            for (Cluster theCluster : this.getClusters()) {
                try {
                    String label = theCluster.getDerivedLabelProbabilities().getDominantKeyInSet(predictLabels);
                    populatedPredictLabels.add(label);
                    ++clustersWithPredictionLabel;
                }
                catch (NoSuchElementException e) {
                    logger.debug("Cluster has no prediction label: " + theCluster);
                }
            }
            result.put(predictionSetName, populatedPredictLabels);
            logger.info(predictionSetName + ": " + clustersWithPredictionLabel + " of " + this.getNumClusters() + " clusters have a prediction label; " + populatedPredictLabels.size() + " labels can be predicted");
        }
        return result;
    }

    public void computeTrainingMass(ClusteringTestResults tr) {
        for (Cluster theCluster : this.getClusters()) {
            tr.incrementTotalTrainingMass(theCluster.getImmutableWeightedLabels().getItemCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getAssignment(String id) {
        Map<String, C> map = this.assignments;
        synchronized (map) {
            return (C)((Cluster)this.assignments.get(id));
        }
    }

    protected void normalizeClusterLabelProbabilities() {
        ProgressReportingThreadPoolExecutor execService = new ProgressReportingThreadPoolExecutor();
        for (final Cluster c : this.getClusters()) {
            execService.submit(new Runnable(){

                public void run() {
                    c.updateDerivedWeightedLabelsFromLocal();
                }
            });
        }
        execService.finish("Normalized %d training probabilities", 30);
    }

    public String shortClusteringStats() {
        return "No clustering stats available";
    }

    protected void testOneSample(DissimilarityMeasure<String> intraLabelDistances, ClusteringTestResults tr, Map<String, Set<String>> populatedPredictLabelSets, T frag) {
        WeightedSet<String> predictedLabelWeights = this.predictLabelWeights(tr, frag);
        this.testAgainstPredictionLabels(intraLabelDistances, tr, populatedPredictLabelSets, frag, predictedLabelWeights);
    }

    protected void testAgainstPredictionLabels(DissimilarityMeasure<String> intraLabelDistances, ClusteringTestResults tr, Map<String, Set<String>> populatedPredictLabelSets, T frag, WeightedSet<String> predictedLabelWeights) {
        boolean unknown = predictedLabelWeights == null;
        WeightedSet<String> fragmentActualLabels = frag.getImmutableWeightedLabels();
        String detailedActualLabel = fragmentActualLabels.getDominantKeyInSet(this.testLabels);
        for (Map.Entry<String, Set<String>> entry : this.predictLabelSets.entrySet()) {
            double detailedWrongness;
            double broadWrongness;
            double clusterProb;
            String predictedLabel;
            String predictionSetName = entry.getKey();
            Set<String> predictLabels = entry.getValue();
            String broadActualLabel = null;
            try {
                broadActualLabel = fragmentActualLabels.getDominantKeyInSet(predictLabels);
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (unknown) {
                predictedLabel = null;
                clusterProb = 0.0;
                if (populatedPredictLabelSets.get(predictionSetName).contains(broadActualLabel)) {
                    tr.incrementShouldNotHaveBeenUnknown(predictionSetName);
                }
                broadWrongness = Double.NaN;
                detailedWrongness = Double.NaN;
            } else {
                try {
                    predictedLabel = predictedLabelWeights.getDominantKeyInSet(predictLabels);
                    clusterProb = predictedLabelWeights.getNormalized(predictedLabel);
                    if (!populatedPredictLabelSets.get(predictionSetName).contains(broadActualLabel)) {
                        tr.incrementShouldHaveBeenUnknown(predictionSetName);
                    }
                    broadWrongness = intraLabelDistances.distanceFromTo(broadActualLabel, predictedLabel);
                    logger.debug("Label distance broad wrongness = " + broadWrongness);
                    if (Double.isNaN(broadWrongness) || Double.isInfinite(broadWrongness)) {
                        logger.error("Broad Wrongness = " + broadWrongness);
                    }
                    detailedWrongness = intraLabelDistances.distanceFromTo(detailedActualLabel, predictedLabel);
                    logger.debug("Label distance detailed wrongness = " + detailedWrongness);
                    if (Double.isNaN(detailedWrongness) || Double.isInfinite(detailedWrongness)) {
                        logger.error("Detailed Wrongness = " + detailedWrongness);
                    }
                }
                catch (NoSuchElementException e) {
                    predictedLabel = null;
                    clusterProb = 0.0;
                    tr.incrementOther(predictionSetName);
                    if (populatedPredictLabelSets.get(predictionSetName).contains(broadActualLabel)) {
                        tr.incrementShouldNotHaveBeenOther(predictionSetName);
                    }
                    broadWrongness = Double.NaN;
                    detailedWrongness = Double.NaN;
                }
            }
            tr.addPredictionResult(predictionSetName, broadActualLabel, predictedLabel, 1.0 - clusterProb, broadWrongness, detailedWrongness);
        }
    }

    protected WeightedSet<String> predictLabelWeights(ClusteringTestResults tr, T frag) {
        double bestVoteProportion;
        double bestDistance;
        double secondToBestDistanceRatio = 0.0;
        double secondToBestVoteRatio = 0.0;
        WeightedSet<String> labelWeights = null;
        try {
            ClusterMove<T, C> cm = this.bestClusterMove(frag);
            bestDistance = cm.bestDistance;
            if (cm.bestDistance != 0.0) {
                secondToBestDistanceRatio = cm.secondBestDistance / cm.bestDistance;
            }
            bestVoteProportion = cm.voteProportion;
            if (cm.voteProportion != 0.0) {
                secondToBestVoteRatio = cm.secondBestVoteProportion / cm.voteProportion;
            }
            labelWeights = cm.bestCluster.getDerivedLabelProbabilities();
        }
        catch (NoGoodClusterException e) {
            bestDistance = Double.NaN;
            secondToBestDistanceRatio = 1.0;
            bestVoteProportion = 0.0;
            secondToBestVoteRatio = 1.0;
            tr.incrementUnknown();
        }
        tr.addClusterResult(bestDistance, secondToBestDistanceRatio, bestVoteProportion, secondToBestVoteRatio);
        return labelWeights;
    }

    public abstract ClusterMove<T, C> bestClusterMove(T var1) throws NoGoodClusterException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAssignmentsAsTextToStream(OutputStream outf) {
        boolean c = false;
        PrintWriter p = new PrintWriter(outf);
        Map<String, C> map = this.assignments;
        synchronized (map) {
            for (Map.Entry<String, C> stringCEntry : this.assignments.entrySet()) {
                p.println(stringCEntry.getKey() + " " + ((Cluster)stringCEntry.getValue()).getId());
            }
        }
        p.flush();
    }
}

