/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import com.davidsoergel.dsutils.LabellableImpl;
import com.davidsoergel.dsutils.collections.ImmutableHashWeightedSet;
import com.davidsoergel.dsutils.collections.WeightedSet;
import edu.berkeley.compbio.ml.cluster.Cluster;
import edu.berkeley.compbio.ml.cluster.Clusterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCluster<T extends Clusterable<T>>
extends LabellableImpl<String>
implements Cluster<T> {
    protected final int id;
    private WeightedSet<String> derivedLabelProbabilities = null;

    public AbstractCluster(int id) {
        this.id = id;
    }

    @Override
    public WeightedSet<String> getDerivedLabelProbabilities() {
        return this.derivedLabelProbabilities;
    }

    @Override
    public void setDerivedLabelProbabilities(ImmutableHashWeightedSet<String> derivedLabelProbabilities) {
        this.derivedLabelProbabilities = derivedLabelProbabilities;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getN() {
        return this.getItemCount();
    }

    @Override
    public void updateDerivedWeightedLabelsFromLocal() {
        this.derivedLabelProbabilities = new ImmutableHashWeightedSet<String>(this.mutableWeightedLabels);
    }

    @Override
    public boolean add(T point2) {
        this.mutableWeightedLabels.addAll(point2.getImmutableWeightedLabels());
        return true;
    }

    @Override
    public boolean addAll(Cluster<T> otherCluster) {
        this.mutableWeightedLabels.addAll(otherCluster.getImmutableWeightedLabels());
        return true;
    }

    @Override
    public boolean remove(T point2) {
        this.mutableWeightedLabels.removeAll(point2.getImmutableWeightedLabels());
        return true;
    }

    @Override
    public boolean removeAll(Cluster<T> otherCluster) {
        this.mutableWeightedLabels.removeAll(otherCluster.getImmutableWeightedLabels());
        return true;
    }

    public int compareTo(Cluster<T> o) {
        return this.id - o.getId();
    }
}

