/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml;

import edu.berkeley.compbio.ml.CrossValidationResults;

public class BinaryCrossValidationResults
extends CrossValidationResults {
    protected int numExamples;
    protected int tt;
    protected int tf;
    protected int ft;
    protected int ff;

    float trueTrueRate() {
        return (float)this.tt / (float)this.numExamples;
    }

    float falseTrueRate() {
        return (float)this.ft / (float)this.numExamples;
    }

    float trueFalseRate() {
        return (float)this.tf / (float)this.numExamples;
    }

    float falseFalseRate() {
        return (float)this.ff / (float)this.numExamples;
    }

    public float accuracy() {
        return (float)(this.tt + this.ff) / (float)this.numExamples;
    }

    public float accuracyGivenClassified() {
        return this.accuracy();
    }

    public float unknown() {
        return 0.0f;
    }

    public float classNormalizedSensitivity() {
        return ((float)this.tt / (float)(this.tt + this.tf) + (float)this.ff / (float)(this.ff + this.ft)) / 2.0f;
    }

    public float sensitivityA() {
        return (float)this.tt / (float)(this.tt + this.tf);
    }

    public float sensitivityB() {
        return (float)this.ff / (float)(this.ff + this.ft);
    }

    public float precisionA() {
        return (float)this.tt / (float)(this.tt + this.ft);
    }

    public int getNumExamples() {
        return this.numExamples;
    }

    public float falseBalance() {
        int denom = this.ft + this.tf;
        if (denom == 0) {
            return 0.0f;
        }
        return 2.0f * ((float)this.tf / (float)denom) - 1.0f;
    }

    public float absFalseBalance() {
        return Math.abs(this.falseBalance());
    }
}

