/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtractionMap<P, L>
extends AbstractMap<P, L> {
    private Set<Map.Entry<P, L>> entries;

    public SubtractionMap(Map<P, L> orig, Set<P> except) {
        this(orig.entrySet(), except);
    }

    public SubtractionMap(Collection<Map.Entry<P, L>> origEntries, Set<P> except) {
        this.entries = new SubtractionEntrySet<P, L>(origEntries, except);
    }

    public SubtractionMap(Map<P, L> orig, Set<P> except, int maxSize) {
        this(orig.entrySet(), except, maxSize);
    }

    public SubtractionMap(Collection<Map.Entry<P, L>> origEntries, Set<P> except, int maxSize) {
        this.entries = new SubtractionEntrySet<P, L>(origEntries, except, maxSize);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Set<Map.Entry<P, L>> entrySet() {
        return this.entries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubtractionEntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        private Collection<Map.Entry<K, V>> orig;
        private Set<K> except;
        private int size;

        public SubtractionEntrySet(Collection<Map.Entry<K, V>> orig, Set<K> except) {
            this(orig, except, Integer.MAX_VALUE);
        }

        public SubtractionEntrySet(Collection<Map.Entry<K, V>> orig, Set<K> except, int maxSize) {
            this.size = maxSize;
            this.orig = orig;
            this.except = except;
            int c = 0;
            Iterator<Map.Entry<K, V>> i = this.iterator();
            while (i.hasNext()) {
                try {
                    i.next();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                ++c;
            }
            this.size = c;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator<Map.Entry<K, V>> oi = this.orig.iterator();
            return new ExceptKeyIterator(oi);
        }

        @Override
        public int size() {
            return this.size;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ExceptKeyIterator
        implements Iterator<Map.Entry<K, V>> {
            Iterator<Map.Entry<K, V>> oi;
            int c = 0;
            Map.Entry<K, V> next;

            private ExceptKeyIterator(Iterator<Map.Entry<K, V>> oi) {
                this.oi = oi;
                this.prepNext();
            }

            private void prepNext() {
                try {
                    do {
                        this.next = this.oi.next();
                    } while (SubtractionEntrySet.this.except.contains(this.next.getKey()));
                }
                catch (NoSuchElementException e) {
                    this.next = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Map.Entry result = this.next;
                this.prepNext();
                ++this.c;
                if (this.c >= SubtractionEntrySet.this.size) {
                    this.next = null;
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

