/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.util;

import java.util.ArrayList;
import java.util.Arrays;

public class SparseVector {
    public int[] indexes;
    public float[] values;

    public SparseVector(int dimensions) {
        this.indexes = new int[dimensions];
        this.values = new float[dimensions];
    }

    public SparseVector(int maxDimensions, float nonzeroProbability, float maxValue) {
        int i;
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (i = 0; i < maxDimensions; ++i) {
            if (!(Math.random() < (double)nonzeroProbability)) continue;
            indexList.add(i);
        }
        this.indexes = new int[indexList.size()];
        this.values = new float[this.indexes.length];
        for (i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = (Integer)indexList.get(i);
            this.values[i] = (float)(Math.random() * (double)maxValue);
        }
    }

    public SparseVector(int maxDimensions, SparseVector sv1, float p1, SparseVector sv2, float p2) {
        int i;
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        ArrayList<Float> valueList = new ArrayList<Float>();
        for (i = 0; i < maxDimensions; ++i) {
            float v = sv1.get(i) * p1 + sv2.get(i) * p2;
            if (v == 0.0f) continue;
            indexList.add(i);
            valueList.add(Float.valueOf(v));
        }
        this.indexes = new int[indexList.size()];
        this.values = new float[this.indexes.length];
        for (i = 0; i < indexList.size(); ++i) {
            this.indexes[i] = (Integer)indexList.get(i);
            this.values[i] = ((Float)valueList.get(i)).floatValue();
        }
    }

    public float get(int i) {
        int j = Arrays.binarySearch(this.indexes, i);
        if (j < 0) {
            return 0.0f;
        }
        return this.values[j];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < this.indexes.length; ++j) {
            sb.append(this.indexes[j] + ":" + this.values[j] + " ");
        }
        return sb.toString();
    }

    public void normalizeL2() {
        double sumOfSquares = 0.0;
        for (float value : this.values) {
            sumOfSquares += (double)(value * value);
        }
        double total = Math.sqrt(sumOfSquares);
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = (float)((double)this.values[n] / total);
        }
    }
}

