/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.util;

import edu.berkeley.compbio.jlibsvm.util.SparseVector;

public class MathSupport {
    public static double powi(double base, int times) {
        assert (times >= 0);
        double tmp = base;
        double ret = 1.0;
        for (int t = times; t > 0; t /= 2) {
            if (t % 2 != 0) {
                ret *= tmp;
            }
            tmp *= tmp;
        }
        return ret;
    }

    public static double dot(SparseVector x, SparseVector y) {
        int[] xIndexes = x.indexes;
        int xlen = xIndexes.length;
        int[] yIndexes = y.indexes;
        int ylen = yIndexes.length;
        float[] xValues = x.values;
        float[] yValues = y.values;
        double sum = 0.0;
        int i = 0;
        int j = 0;
        int xIndex = xIndexes[0];
        int yIndex = yIndexes[0];
        while (i < xlen && j < ylen) {
            if (xIndex == yIndex) {
                sum += (double)xValues[i] * (double)yValues[j];
                xIndex = ++i >= xlen ? Integer.MAX_VALUE : xIndexes[i];
                if (++j >= ylen) {
                    yIndex = Integer.MAX_VALUE;
                    continue;
                }
                yIndex = yIndexes[j];
                continue;
            }
            try {
                while (xIndex > yIndex) {
                    yIndex = yIndexes[++j];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                yIndex = Integer.MAX_VALUE;
            }
            try {
                while (yIndex > xIndex) {
                    xIndex = xIndexes[++i];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                xIndex = Integer.MAX_VALUE;
            }
        }
        return sum;
    }

    public static boolean[] toPrimitive(Boolean[] x) {
        boolean[] result = new boolean[x.length];
        int i = 0;
        for (Boolean b : x) {
            result[i] = b;
            ++i;
        }
        return result;
    }
}

