/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.scaler;

import edu.berkeley.compbio.jlibsvm.scaler.ScalingModel;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.util.SparseVector;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZscoreScalingModelLearner
implements ScalingModelLearner<SparseVector> {
    private final int maxExamples;
    private final boolean normalizeL2;

    public static float runningMean(int sampleCount, float priorMean, float value) {
        float d = sampleCount;
        return priorMean + (value - priorMean) / d;
    }

    public static float runningStddevQ(int sampleCount, float priorMean, float priorQ, float value) {
        float d = value - priorMean;
        float result = priorQ + (float)(sampleCount - 1) * d * d / (float)sampleCount;
        return result;
    }

    public static void runningStddevQtoStddevInPlace(Map<Integer, Float> stddevQ, int sampleCount) {
        float d = sampleCount;
        for (Map.Entry<Integer, Float> entry : stddevQ.entrySet()) {
            entry.setValue(new Float(Math.sqrt(entry.getValue().floatValue() / d)));
        }
    }

    public ZscoreScalingModelLearner(int scalingExamples, boolean normalizeL2) {
        this.maxExamples = scalingExamples;
        this.normalizeL2 = normalizeL2;
    }

    @Override
    public ScalingModel<SparseVector> learnScaling(Iterable<SparseVector> examples) {
        HashMap<Integer, Float> mean = new HashMap<Integer, Float>();
        HashMap<Integer, Float> stddevQ = new HashMap<Integer, Float>();
        int sampleCount = 0;
        for (SparseVector example : examples) {
            if (sampleCount >= this.maxExamples) break;
            ++sampleCount;
            for (int index : example.indexes) {
                float v = example.get(index);
                Float currentMean = (Float)mean.get(index);
                if (currentMean == null) {
                    mean.put(index, Float.valueOf(v));
                    stddevQ.put(index, Float.valueOf(0.0f));
                    continue;
                }
                mean.put(index, Float.valueOf(ZscoreScalingModelLearner.runningMean(sampleCount, currentMean.floatValue(), v)));
                stddevQ.put(index, Float.valueOf(ZscoreScalingModelLearner.runningStddevQ(sampleCount, currentMean.floatValue(), ((Float)stddevQ.get(index)).floatValue(), v)));
            }
        }
        ZscoreScalingModelLearner.runningStddevQtoStddevInPlace(stddevQ, sampleCount);
        return new ZscoreScalingModel(mean, stddevQ);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZscoreScalingModel
    implements ScalingModel<SparseVector> {
        private final Map<Integer, Float> mean;
        private final Map<Integer, Float> stddev;

        public ZscoreScalingModel(Map<Integer, Float> mean, Map<Integer, Float> stddev) {
            this.mean = mean;
            this.stddev = stddev;
        }

        @Override
        public SparseVector scaledCopy(SparseVector example) {
            SparseVector result = new SparseVector(example.indexes.length);
            for (int i = 0; i < example.indexes.length; ++i) {
                int index = example.indexes[i];
                float v = example.values[i];
                result.indexes[i] = index;
                Float theMean = this.mean.get(index);
                if (theMean == null) continue;
                result.values[i] = (v - theMean.floatValue()) / this.stddev.get(index).floatValue();
            }
            if (ZscoreScalingModelLearner.this.normalizeL2) {
                result.normalizeL2();
            }
            return result;
        }
    }
}

