/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.scaler;

import edu.berkeley.compbio.jlibsvm.scaler.ScalingModel;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.util.SparseVector;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearScalingModelLearner
implements ScalingModelLearner<SparseVector> {
    private final int maxExamples;
    private final boolean normalizeL2;

    public LinearScalingModelLearner(int scalingExamples, boolean normalizeL2) {
        this.maxExamples = scalingExamples;
        this.normalizeL2 = normalizeL2;
    }

    @Override
    public ScalingModel<SparseVector> learnScaling(Iterable<SparseVector> examples) {
        HashMap<Integer, Float> minima = new HashMap<Integer, Float>();
        HashMap<Integer, Float> sizes = new HashMap<Integer, Float>();
        int count = 0;
        for (SparseVector example : examples) {
            if (count >= this.maxExamples) break;
            for (int index : example.indexes) {
                float v = example.get(index);
                Float currentMin = (Float)minima.get(index);
                if (currentMin == null) {
                    minima.put(index, Float.valueOf(v));
                    sizes.put(index, Float.valueOf(0.0f));
                    continue;
                }
                minima.put(index, Float.valueOf(Math.min(((Float)minima.get(index)).floatValue(), v)));
                sizes.put(index, Float.valueOf(Math.max(((Float)sizes.get(index)).floatValue(), v - ((Float)minima.get(index)).floatValue())));
            }
            ++count;
        }
        return new LinearScalingModel(minima, sizes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LinearScalingModel
    implements ScalingModel<SparseVector> {
        Map<Integer, Float> minima;
        Map<Integer, Float> sizes;

        public LinearScalingModel(Map<Integer, Float> minima, Map<Integer, Float> sizes) {
            this.minima = minima;
            this.sizes = sizes;
        }

        @Override
        public SparseVector scaledCopy(SparseVector example) {
            SparseVector result = new SparseVector(example.indexes.length);
            for (int i = 0; i < example.indexes.length; ++i) {
                int index = example.indexes[i];
                float v = example.values[i];
                result.indexes[i] = index;
                Float min = this.minima.get(index);
                if (min == null) continue;
                result.values[i] = 2.0f * (v - min.floatValue()) / this.sizes.get(index).floatValue() - 1.0f;
            }
            if (LinearScalingModelLearner.this.normalizeL2) {
                result.normalizeL2();
            }
            return result;
        }
    }
}

