/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.regression;

import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.Solver_NU;
import edu.berkeley.compbio.jlibsvm.qmatrix.QMatrix;
import edu.berkeley.compbio.jlibsvm.regression.RegressionModel;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionSolverNu<P>
extends Solver_NU<Float, P> {
    private static final Logger logger = Logger.getLogger(RegressionSolverNu.class);

    public RegressionSolverNu(List<SolutionVector<P>> solutionVectors, QMatrix<P> Q, float C, float eps, boolean shrinking) {
        super(solutionVectors, Q, C, C, eps, shrinking);
    }

    public RegressionModel<P> solve() {
        int iter = this.optimize();
        RegressionModel model = new RegressionModel();
        this.calculate_rho(model);
        model.supportVectors = new HashMap();
        for (SolutionVector svC : this.allExamples) {
            Double alphaDiff = (Double)model.supportVectors.get(svC.point);
            if (alphaDiff == null) {
                alphaDiff = 0.0;
            }
            alphaDiff = alphaDiff + (svC.targetValue ? 1.0 : -1.0) * svC.alpha;
            model.supportVectors.put(svC.point, alphaDiff);
        }
        logger.info("optimization finished, #iter = " + iter);
        return model;
    }
}

