/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.regression;

import edu.berkeley.compbio.jlibsvm.ContinuousModel;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.binary.AlphaModel;
import edu.berkeley.compbio.jlibsvm.regression.RegressionCrossValidationResults;
import edu.berkeley.compbio.ml.CrossValidationResults;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionModel<P>
extends AlphaModel<Float, P>
implements ContinuousModel<P> {
    public ImmutableSvmParameterPoint<Float, P> param;
    public static final float NO_LAPLACE_PARAMETER = -1.0f;
    public float laplaceParameter = -1.0f;
    public float r;
    public RegressionCrossValidationResults crossValidationResults;

    @Override
    public CrossValidationResults getCrossValidationResults() {
        return this.crossValidationResults;
    }

    public float getLaplaceParameter() {
        if (this.laplaceParameter == -1.0f) {
            throw new SvmException("Model doesn't contain information for SVR probability inference\n");
        }
        return this.laplaceParameter;
    }

    @Override
    public Float predictValue(P x) {
        float sum = 0.0f;
        for (int i = 0; i < this.numSVs; ++i) {
            sum = (float)((double)sum + this.alphas[i] * this.param.kernel.evaluate(x, this.SVs[i]));
        }
        return Float.valueOf(sum -= this.rho);
    }

    public boolean supportsLaplace() {
        return this.laplaceParameter != -1.0f;
    }

    @Override
    public void writeToStream(DataOutputStream fp) throws IOException {
        super.writeToStream(fp);
        fp.writeBytes("probA " + this.laplaceParameter + "\n");
        this.writeSupportVectors(fp);
        fp.close();
    }
}

