/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.qmatrix;

import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.kernel.KernelFunction;
import edu.berkeley.compbio.jlibsvm.qmatrix.QMatrix;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KernelQMatrix<P>
implements QMatrix<P> {
    protected KernelFunction<P> kernel;
    private RecentActivitySquareCache cache;

    KernelQMatrix(@NotNull KernelFunction<P> kernel, int numExamples, int cacheRows) {
        this.kernel = kernel;
        this.cache = new RecentActivitySquareCache(numExamples, cacheRows);
    }

    @Override
    public final float evaluateDiagonal(SolutionVector<P> a) {
        return this.cache.getDiagonal(a);
    }

    @Override
    public void getQ(SolutionVector<P> svA, SolutionVector<P>[] active, float[] buf) {
        this.cache.get(svA, active, buf);
    }

    @Override
    public void getQ(SolutionVector<P> svA, SolutionVector<P>[] active, SolutionVector<P>[] inactive, float[] buf) {
        this.cache.get(svA, active, inactive, buf);
    }

    @Override
    public void initRanks(Collection<SolutionVector<P>> allExamples) {
        int c = 0;
        for (SolutionVector<P> a : allExamples) {
            a.rank = c++;
        }
    }

    @Override
    public void maintainCache(SolutionVector<P>[] active, SolutionVector<P>[] newlyInactive) {
        this.cache.maintainCache(active, newlyInactive);
    }

    @Override
    public String perfString() {
        return this.cache.toString();
    }

    public abstract float computeQ(SolutionVector<P> var1, SolutionVector<P> var2);

    public final float evaluate(SolutionVector<P> a, SolutionVector<P> b) {
        return this.cache.get(a, b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecentActivitySquareCache {
        public static final float NOTCACHED = Float.NEGATIVE_INFINITY;
        float[][] data;
        float[] diagonal;
        int maxCachedRank;
        long hits = 0L;
        long misses = 0L;
        long widemisses = 0L;
        long diagonalhits = 0L;
        long diagonalmisses = 0L;

        public RecentActivitySquareCache(int numExamples, int cacheRows) {
            this.maxCachedRank = Math.min(numExamples, cacheRows);
            this.data = new float[this.maxCachedRank][];
            for (int i = 0; i < this.maxCachedRank; ++i) {
                this.data[i] = new float[this.maxCachedRank];
                Arrays.fill(this.data[i], Float.NEGATIVE_INFINITY);
            }
            this.diagonal = new float[numExamples];
            Arrays.fill(this.diagonal, Float.NEGATIVE_INFINITY);
        }

        public String toString() {
            return "QMatrix hits = " + this.hits + ", misses = " + this.misses + ", widemisses = " + this.widemisses + ", diagonalhits = " + this.diagonalhits + ", diagonalmisses = " + this.diagonalmisses + ", rate = " + (float)(this.hits + this.diagonalhits) / (float)(this.hits + this.diagonalhits + this.misses + this.widemisses + this.diagonalmisses) + ", size = " + this.data.length;
        }

        public float get(SolutionVector<P> a, SolutionVector<P> b) {
            if (a == b) {
                return this.getDiagonal(a);
            }
            if (a.rank >= this.maxCachedRank || b.rank >= this.maxCachedRank) {
                ++this.widemisses;
                return KernelQMatrix.this.computeQ(a, b);
            }
            float result = this.data[a.rank][b.rank];
            if (result == Float.NEGATIVE_INFINITY) {
                this.data[a.rank][b.rank] = result = KernelQMatrix.this.computeQ(a, b);
                this.data[b.rank][a.rank] = result;
                ++this.misses;
            } else {
                ++this.hits;
            }
            return result;
        }

        public float getDiagonal(SolutionVector<P> a) {
            float result = this.diagonal[a.rank];
            if (result == Float.NEGATIVE_INFINITY) {
                this.diagonal[a.rank] = result = KernelQMatrix.this.computeQ(a, a);
                ++this.diagonalmisses;
            } else {
                ++this.diagonalhits;
            }
            return result;
        }

        public void get(SolutionVector<P> a, SolutionVector<P>[] active, float[] buf) {
            SolutionVector b;
            int i;
            if (a.rank >= this.maxCachedRank) {
                for (int i2 = 0; i2 < active.length; ++i2) {
                    buf[i2] = KernelQMatrix.this.computeQ(a, active[i2]);
                    ++this.widemisses;
                }
                return;
            }
            float[] row = this.data[a.rank];
            int cachedAndActive = Math.min(row.length, active.length);
            for (i = 0; i < cachedAndActive; ++i) {
                if (row[i] == Float.NEGATIVE_INFINITY) {
                    b = active[i];
                    row[i] = KernelQMatrix.this.computeQ(a, b);
                    this.data[b.rank][a.rank] = row[i];
                    ++this.misses;
                    continue;
                }
                b = active[i];
                ++this.hits;
            }
            System.arraycopy(row, 0, buf, 0, cachedAndActive);
            for (i = cachedAndActive; i < active.length; ++i) {
                b = active[i];
                buf[i] = KernelQMatrix.this.computeQ(a, b);
                ++this.widemisses;
            }
        }

        public void get(SolutionVector<P> a, SolutionVector<P>[] active, SolutionVector<P>[] inactive, float[] buf) {
            this.get(a, active, buf);
            if (a.rank >= this.maxCachedRank) {
                int i = active.length;
                for (SolutionVector b : inactive) {
                    buf[i] = KernelQMatrix.this.computeQ(a, b);
                    ++this.widemisses;
                    ++i;
                }
            } else {
                float[] row = this.data[a.rank];
                int i = active.length;
                for (SolutionVector b : inactive) {
                    if (b.rank >= this.maxCachedRank) {
                        buf[i] = KernelQMatrix.this.computeQ(a, b);
                        ++this.widemisses;
                    } else {
                        if (row[b.rank] == Float.NEGATIVE_INFINITY) {
                            row[b.rank] = KernelQMatrix.this.computeQ(a, b);
                            this.data[b.rank][a.rank] = row[b.rank];
                            ++this.misses;
                        } else {
                            ++this.hits;
                        }
                        buf[i] = row[b.rank];
                    }
                    ++i;
                }
            }
        }

        public void maintainCache(SolutionVector<P>[] active, SolutionVector<P>[] newlyInactive) {
            int partitionRank = active.length;
            int i = 0;
            int j = 0;
            while (true) {
                if (i < active.length && active[i].rank < partitionRank) {
                    ++i;
                    continue;
                }
                while (j < newlyInactive.length && newlyInactive[j].rank >= partitionRank) {
                    ++j;
                }
                if (i >= active.length || j >= newlyInactive.length) break;
                this.swapBySolutionVector(active[i], newlyInactive[j]);
                ++i;
                ++j;
            }
        }

        private void swapBySolutionVector(SolutionVector<P> svA, SolutionVector<P> svB) {
            this.swapByRank(svA.rank, svB.rank);
            int tmp = svA.rank;
            svA.rank = svB.rank;
            svB.rank = tmp;
        }

        private void swapByRank(int rankA, int rankB) {
            float tmp = this.diagonal[rankA];
            this.diagonal[rankA] = this.diagonal[rankB];
            this.diagonal[rankB] = tmp;
            if (rankA < this.maxCachedRank || rankB < this.maxCachedRank) {
                if (rankA < this.maxCachedRank && rankB < this.maxCachedRank) {
                    float[] dtmp = this.data[rankA];
                    this.data[rankA] = this.data[rankB];
                    this.data[rankB] = dtmp;
                    for (float[] drow : this.data) {
                        float d = drow[rankA];
                        drow[rankA] = drow[rankB];
                        drow[rankB] = d;
                    }
                } else if (rankA < this.maxCachedRank) {
                    Arrays.fill(this.data[rankA], Float.NEGATIVE_INFINITY);
                } else {
                    Arrays.fill(this.data[rankB], Float.NEGATIVE_INFINITY);
                }
            }
        }
    }
}

