/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.legacyexec;

import edu.berkeley.compbio.jlibsvm.ContinuousModel;
import edu.berkeley.compbio.jlibsvm.DiscreteModel;
import edu.berkeley.compbio.jlibsvm.ExplicitSvmProblemImpl;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.SVM;
import edu.berkeley.compbio.jlibsvm.SolutionModel;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationSVM;
import edu.berkeley.compbio.jlibsvm.binary.C_SVC;
import edu.berkeley.compbio.jlibsvm.binary.MutableBinaryClassificationProblemImpl;
import edu.berkeley.compbio.jlibsvm.binary.Nu_SVC;
import edu.berkeley.compbio.jlibsvm.kernel.GammaKernel;
import edu.berkeley.compbio.jlibsvm.kernel.GaussianRBFKernel;
import edu.berkeley.compbio.jlibsvm.kernel.LinearKernel;
import edu.berkeley.compbio.jlibsvm.kernel.PolynomialKernel;
import edu.berkeley.compbio.jlibsvm.kernel.PrecomputedKernel;
import edu.berkeley.compbio.jlibsvm.kernel.SigmoidKernel;
import edu.berkeley.compbio.jlibsvm.labelinverter.ByteLabelInverter;
import edu.berkeley.compbio.jlibsvm.legacyexec.AppletFrame;
import edu.berkeley.compbio.jlibsvm.multi.MultiClassificationSVM;
import edu.berkeley.compbio.jlibsvm.multi.MutableMultiClassProblemImpl;
import edu.berkeley.compbio.jlibsvm.oneclass.OneClassSVC;
import edu.berkeley.compbio.jlibsvm.regression.EpsilonSVR;
import edu.berkeley.compbio.jlibsvm.regression.MutableRegressionProblemImpl;
import edu.berkeley.compbio.jlibsvm.regression.Nu_SVR;
import edu.berkeley.compbio.jlibsvm.regression.RegressionSVM;
import edu.berkeley.compbio.jlibsvm.scaler.NoopScalingModel;
import edu.berkeley.compbio.jlibsvm.util.SparseVector;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;

public class svm_toy
extends Applet {
    static final String DEFAULT_PARAM = "-t 2 -c 100";
    static final Color[] colors = new Color[]{new Color(0, 0, 0), new Color(0, 120, 120), new Color(120, 120, 0), new Color(120, 0, 120), new Color(0, 200, 200), new Color(200, 200, 0), new Color(200, 0, 200)};
    int XLEN;
    int YLEN;
    Image buffer;
    Graphics buffer_gc;
    Vector<point> point_list = new Vector();
    byte current_value = 1;
    ImmutableSvmParameterPoint param;

    public Dimension getPreferredSize() {
        return new Dimension(this.XLEN, this.YLEN + 50);
    }

    public void init() {
        this.setSize(this.getSize());
        final Button button_change = new Button("Change");
        Button button_run = new Button("Run");
        Button button_clear = new Button("Clear");
        Button button_save = new Button("Save");
        Button button_load = new Button("Load");
        final TextField input_line = new TextField(DEFAULT_PARAM);
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        Panel p = new Panel();
        GridBagLayout gridbag = new GridBagLayout();
        p.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        gridbag.setConstraints(button_change, c);
        gridbag.setConstraints(button_run, c);
        gridbag.setConstraints(button_clear, c);
        gridbag.setConstraints(button_save, c);
        gridbag.setConstraints(button_load, c);
        c.weightx = 5.0;
        c.gridwidth = 5;
        gridbag.setConstraints(input_line, c);
        button_change.setBackground(colors[this.current_value]);
        p.add(button_change);
        p.add(button_run);
        p.add(button_clear);
        p.add(button_save);
        p.add(button_load);
        p.add(input_line);
        this.add((Component)p, "South");
        button_change.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                svm_toy.this.button_change_clicked();
                button_change.setBackground(colors[svm_toy.this.current_value]);
            }
        });
        button_run.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                svm_toy.this.button_run_clicked(input_line.getText());
            }
        });
        button_clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                svm_toy.this.button_clear_clicked();
            }
        });
        button_save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                svm_toy.this.button_save_clicked();
            }
        });
        button_load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                svm_toy.this.button_load_clicked();
            }
        });
        input_line.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                svm_toy.this.button_run_clicked(input_line.getText());
            }
        });
        this.enableEvents(16L);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    void button_change_clicked() {
        this.current_value = (byte)(this.current_value + 1);
        if (this.current_value > 3) {
            this.current_value = 1;
        }
    }

    void button_clear_clicked() {
        this.clear_all();
    }

    void clear_all() {
        this.point_list.removeAllElements();
        if (this.buffer != null) {
            this.buffer_gc.setColor(colors[0]);
            this.buffer_gc.fillRect(0, 0, this.XLEN, this.YLEN);
        }
        this.repaint();
    }

    void button_save_clicked() {
        FileDialog dialog = new FileDialog(new Frame(), "Save", 1);
        dialog.setVisible(true);
        String filename = dialog.getDirectory() + File.separator + dialog.getFile();
        if (filename == null) {
            return;
        }
        try {
            DataOutputStream fp = new DataOutputStream(new FileOutputStream(filename));
            int n = this.point_list.size();
            for (int i = 0; i < n; ++i) {
                point p = this.point_list.elementAt(i);
                fp.writeBytes(p.value + " 1:" + p.x + " 2:" + p.y + "\n");
            }
            fp.close();
        }
        catch (IOException e) {
            System.err.print(e);
        }
    }

    void button_load_clicked() {
        FileDialog dialog = new FileDialog(new Frame(), "Load", 0);
        dialog.setVisible(true);
        String filename = dialog.getDirectory() + File.separator + dialog.getFile();
        if (filename == null) {
            return;
        }
        this.clear_all();
        try {
            String line;
            BufferedReader fp = new BufferedReader(new FileReader(filename));
            while ((line = fp.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
                byte value = (byte)Integer.parseInt(st.nextToken());
                st.nextToken();
                float x = Float.parseFloat(st.nextToken());
                st.nextToken();
                float y = Float.parseFloat(st.nextToken());
                this.point_list.addElement(new point(x, y, value));
            }
            fp.close();
        }
        catch (IOException e) {
            System.err.print(e);
        }
        this.draw_all_points();
    }

    void draw_all_points() {
        int n = this.point_list.size();
        for (int i = 0; i < n; ++i) {
            this.draw_point(this.point_list.elementAt(i));
        }
    }

    void draw_point(point p) {
        Color c = colors[p.value + 3];
        Graphics window_gc = this.getGraphics();
        this.buffer_gc.setColor(c);
        this.buffer_gc.fillRect((int)(p.x * (float)this.XLEN), (int)(p.y * (float)this.YLEN), 4, 4);
        window_gc.setColor(c);
        window_gc.fillRect((int)(p.x * (float)this.XLEN), (int)(p.y * (float)this.YLEN), 4, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void button_run_clicked(String args) {
        SVM svm;
        if (this.point_list.isEmpty()) {
            return;
        }
        ImmutableSvmParameterPoint.Builder paramPointBuilder = new ImmutableSvmParameterPoint.Builder();
        paramPointBuilder.nu = 0.5f;
        paramPointBuilder.cache_size = 40.0f;
        paramPointBuilder.C = 1.0f;
        paramPointBuilder.eps = 0.001f;
        paramPointBuilder.p = 0.1f;
        paramPointBuilder.shrinking = true;
        paramPointBuilder.probability = false;
        StringTokenizer st = new StringTokenizer(args);
        String[] argv = new String[st.countTokens()];
        for (int i = 0; i < argv.length; ++i) {
            argv[i] = st.nextToken();
        }
        int svm_type = 0;
        int kernel_type = 2;
        int degree = 3;
        float gamma = 0.0f;
        float coef0 = 0.0f;
        block31: for (int i = 0; i < argv.length && argv[i].charAt(0) == '-'; ++i) {
            if (++i >= argv.length) {
                System.err.print("unknown option\n");
                break;
            }
            switch (argv[i - 1].charAt(1)) {
                case 's': {
                    svm_type = Integer.parseInt(argv[i]);
                    continue block31;
                }
                case 't': {
                    kernel_type = Integer.parseInt(argv[i]);
                    continue block31;
                }
                case 'd': {
                    degree = Integer.parseInt(argv[i]);
                    continue block31;
                }
                case 'g': {
                    gamma = Float.parseFloat(argv[i]);
                    continue block31;
                }
                case 'r': {
                    coef0 = Float.parseFloat(argv[i]);
                    continue block31;
                }
                case 'n': {
                    paramPointBuilder.nu = Float.parseFloat(argv[i]);
                    continue block31;
                }
                case 'm': {
                    paramPointBuilder.cache_size = Float.parseFloat(argv[i]);
                    continue block31;
                }
                case 'c': {
                    paramPointBuilder.C = Float.parseFloat(argv[i]);
                    continue block31;
                }
                case 'e': {
                    paramPointBuilder.eps = Float.parseFloat(argv[i]);
                    continue block31;
                }
                case 'p': {
                    paramPointBuilder.p = Float.parseFloat(argv[i]);
                    continue block31;
                }
                case 'h': {
                    paramPointBuilder.shrinking = Boolean.parseBoolean(argv[i]);
                    continue block31;
                }
                case 'b': {
                    paramPointBuilder.probability = Boolean.parseBoolean(argv[i]);
                    continue block31;
                }
                case 'u': {
                    paramPointBuilder.redistributeUnbalancedC = Boolean.parseBoolean(argv[i]);
                    continue block31;
                }
                case 'w': {
                    paramPointBuilder.putWeight(Integer.parseInt(argv[i - 1].substring(2)), Float.valueOf(Float.parseFloat(argv[i])));
                    continue block31;
                }
                default: {
                    System.err.print("unknown option\n");
                }
            }
        }
        switch (kernel_type) {
            case 0: {
                paramPointBuilder.kernel = new LinearKernel();
                break;
            }
            case 1: {
                paramPointBuilder.kernel = new PolynomialKernel(degree, gamma, coef0);
                break;
            }
            case 2: {
                paramPointBuilder.kernel = new GaussianRBFKernel(gamma);
                break;
            }
            case 3: {
                paramPointBuilder.kernel = new SigmoidKernel(gamma, coef0);
                break;
            }
            case 4: {
                paramPointBuilder.kernel = new PrecomputedKernel();
                break;
            }
            default: {
                throw new SvmException("Unknown kernel type: " + kernel_type);
            }
        }
        this.param = paramPointBuilder.build();
        switch (svm_type) {
            case 0: {
                svm = new C_SVC();
                break;
            }
            case 1: {
                svm = new Nu_SVC();
                break;
            }
            case 2: {
                svm = new OneClassSVC();
                break;
            }
            case 3: {
                svm = new EpsilonSVR();
                break;
            }
            case 4: {
                svm = new Nu_SVR();
                break;
            }
            default: {
                throw new SvmException("Unknown svm type: " + kernel_type);
            }
        }
        HashSet<Byte> uniqueClasses = new HashSet<Byte>();
        for (point point2 : this.point_list) {
            uniqueClasses.add(point2.value);
        }
        int numClasses = uniqueClasses.size();
        ExplicitSvmProblemImpl prob = svm instanceof RegressionSVM ? new MutableRegressionProblemImpl(this.point_list.size()) : (numClasses == 1 ? new MutableRegressionProblemImpl(this.point_list.size()) : (numClasses == 2 ? new MutableBinaryClassificationProblemImpl(Byte.class, this.point_list.size()) : new MutableMultiClassProblemImpl(Byte.class, new ByteLabelInverter(), this.point_list.size(), new NoopScalingModel())));
        if (kernel_type == 4) {
            throw new SvmException("Can't use precomputed kernel with svm_toy");
        }
        if (svm_type == 3 || svm_type == 4) {
            if (this.param.kernel instanceof GammaKernel && ((GammaKernel)this.param.kernel).getGamma() == 0.0) {
                ((GammaKernel)this.param.kernel).setGamma(1.0);
            }
            for (int i = 0; i < this.point_list.size(); ++i) {
                point p = this.point_list.elementAt(i);
                SparseVector v = new SparseVector(1);
                v.indexes[0] = 1;
                v.values[0] = p.x;
                prob.addExampleFloat(v, Float.valueOf(p.y));
            }
            ContinuousModel model = (ContinuousModel)((Object)svm.train(prob, this.param));
            SparseVector x = new SparseVector(1);
            x.indexes[0] = 1;
            int[] j = new int[this.XLEN];
            Graphics window_gc = this.getGraphics();
            for (int i = 0; i < this.XLEN; ++i) {
                x.values[0] = (float)i / (float)this.XLEN;
                j[i] = (int)((float)this.YLEN * model.predictValue(x).floatValue());
            }
            this.buffer_gc.setColor(colors[0]);
            this.buffer_gc.drawLine(0, 0, 0, this.YLEN - 1);
            window_gc.setColor(colors[0]);
            window_gc.drawLine(0, 0, 0, this.YLEN - 1);
            int p = (int)(paramPointBuilder.p * (float)this.YLEN);
            for (int i = 1; i < this.XLEN; ++i) {
                this.buffer_gc.setColor(colors[0]);
                this.buffer_gc.drawLine(i, 0, i, this.YLEN - 1);
                window_gc.setColor(colors[0]);
                window_gc.drawLine(i, 0, i, this.YLEN - 1);
                this.buffer_gc.setColor(colors[5]);
                window_gc.setColor(colors[5]);
                this.buffer_gc.drawLine(i - 1, j[i - 1], i, j[i]);
                window_gc.drawLine(i - 1, j[i - 1], i, j[i]);
                if (svm_type != 3) continue;
                this.buffer_gc.setColor(colors[2]);
                window_gc.setColor(colors[2]);
                this.buffer_gc.drawLine(i - 1, j[i - 1] + p, i, j[i] + p);
                window_gc.drawLine(i - 1, j[i - 1] + p, i, j[i] + p);
                this.buffer_gc.setColor(colors[2]);
                window_gc.setColor(colors[2]);
                this.buffer_gc.drawLine(i - 1, j[i - 1] - p, i, j[i] - p);
                window_gc.drawLine(i - 1, j[i - 1] - p, i, j[i] - p);
            }
        } else {
            if (this.param.kernel instanceof GammaKernel && ((GammaKernel)this.param.kernel).getGamma() == 0.0) {
                ((GammaKernel)this.param.kernel).setGamma(0.5);
            }
            for (int i = 0; i < this.point_list.size(); ++i) {
                point p = this.point_list.elementAt(i);
                SparseVector v = new SparseVector(2);
                v.indexes[0] = 1;
                v.values[0] = p.x;
                v.indexes[1] = 2;
                v.values[1] = p.y;
                prob.addExample(v, p.value);
            }
            if (svm instanceof BinaryClassificationSVM && prob.getLabels().size() > 2) {
                svm = new MultiClassificationSVM((BinaryClassificationSVM)svm);
            }
            SolutionModel model = svm.train(prob, this.param);
            SparseVector x = new SparseVector(2);
            x.indexes[0] = 1;
            x.indexes[1] = 2;
            Graphics window_gc = this.getGraphics();
            for (int i = 0; i < this.XLEN; ++i) {
                for (int j = 0; j < this.YLEN; ++j) {
                    int d;
                    x.values[0] = (float)i / (float)this.XLEN;
                    x.values[1] = (float)j / (float)this.YLEN;
                    if (model instanceof DiscreteModel) {
                        Object o = ((DiscreteModel)((Object)model)).predictLabel(x);
                        if (o instanceof Boolean) {
                            d = (Boolean)o != false ? 1 : 2;
                        } else if (o instanceof Integer) {
                            d = (Integer)o;
                        } else {
                            if (!(o instanceof Byte)) throw new SvmException("Don't know how to plot label of type " + o.getClass());
                            d = ((Byte)o).byteValue();
                        }
                    } else {
                        d = ((ContinuousModel)((Object)model)).predictValue(x).intValue();
                    }
                    this.buffer_gc.setColor(colors[d]);
                    window_gc.setColor(colors[d]);
                    this.buffer_gc.drawLine(i, j, i, j);
                    window_gc.drawLine(i, j, i, j);
                }
            }
        }
        this.draw_all_points();
    }

    public void paint(Graphics g) {
        if (this.buffer == null) {
            this.buffer = this.createImage(this.XLEN, this.YLEN);
            this.buffer_gc = this.buffer.getGraphics();
            this.buffer_gc.setColor(colors[0]);
            this.buffer_gc.fillRect(0, 0, this.XLEN, this.YLEN);
        }
        g.drawImage(this.buffer, 0, 0, this);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            if (e.getX() >= this.XLEN || e.getY() >= this.YLEN) {
                return;
            }
            point p = new point((float)e.getX() / (float)this.XLEN, (float)e.getY() / (float)this.YLEN, this.current_value);
            this.point_list.addElement(p);
            this.draw_point(p);
        }
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.XLEN = w;
        this.YLEN = h - 50;
        this.clear_all();
    }

    public static void main(String[] argv) {
        new AppletFrame("svm_toy", new svm_toy(), 500, 550);
    }

    static class point {
        float x;
        float y;
        byte value;

        point(float x, float y, byte value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }
    }
}

