/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.kernel;

import edu.berkeley.compbio.jlibsvm.kernel.GammaKernel;
import edu.berkeley.compbio.jlibsvm.util.MathSupport;
import edu.berkeley.compbio.jlibsvm.util.SparseVector;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigmoidKernel
extends GammaKernel<SparseVector> {
    public float coef0;

    public SigmoidKernel(Properties props) {
        this(Float.parseFloat(props.getProperty("gamma")), Float.parseFloat(props.getProperty("coef0")));
    }

    public SigmoidKernel(float gamma, float coef0) {
        super(gamma);
        this.coef0 = coef0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("kernel_type sigmoid\n");
        sb.append("gamma " + this.gamma + "\n");
        sb.append("coef0 " + this.coef0 + "\n");
        return sb.toString();
    }

    @Override
    public double evaluate(SparseVector x, SparseVector y) {
        return Math.tanh(this.gamma * MathSupport.dot(x, y) + (double)this.coef0);
    }
}

