/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.kernel;

import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.kernel.GammaKernel;
import edu.berkeley.compbio.jlibsvm.util.MathSupport;
import edu.berkeley.compbio.jlibsvm.util.SparseVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynomialKernel
extends GammaKernel<SparseVector> {
    public int degree;
    public float coef0;

    public PolynomialKernel(int degree, float gamma, float coef0) {
        super(gamma);
        if (degree < 0) {
            throw new SvmException("degree of polynomial kernel < 0");
        }
        this.degree = degree;
        this.coef0 = coef0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("kernel_type polynomial\n");
        sb.append("degree " + this.degree + "\n");
        sb.append("gamma " + this.gamma + "\n");
        sb.append("coef0 " + this.coef0 + "\n");
        return sb.toString();
    }

    @Override
    public double evaluate(SparseVector x, SparseVector y) {
        return MathSupport.powi(this.gamma * MathSupport.dot(x, y) + (double)this.coef0, this.degree);
    }
}

