/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.kernel;

import edu.berkeley.compbio.jlibsvm.kernel.GammaKernel;
import edu.berkeley.compbio.jlibsvm.util.SparseVector;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianRBFKernel
extends GammaKernel<SparseVector> {
    private static final double explicitSumOptimized(SparseVector x, SparseVector y) {
        double sum = 0.0;
        int[] xIndexes = x.indexes;
        int xlen = xIndexes.length;
        int[] yIndexes = y.indexes;
        int ylen = yIndexes.length;
        float[] xValues = x.values;
        float[] yValues = y.values;
        int i = 0;
        int j = 0;
        int xIndex = xIndexes[0];
        int yIndex = yIndexes[0];
        while (xIndex != Integer.MAX_VALUE || yIndex != Integer.MAX_VALUE) {
            if (xIndex == yIndex) {
                double d = (double)xValues[i] - (double)yValues[j];
                sum += d * d;
                xIndex = ++i >= xlen ? Integer.MAX_VALUE : xIndexes[i];
                if (++j >= ylen) {
                    yIndex = Integer.MAX_VALUE;
                    continue;
                }
                yIndex = yIndexes[j];
                continue;
            }
            try {
                while (xIndex > yIndex) {
                    sum += (double)yValues[j] * (double)yValues[j];
                    yIndex = yIndexes[++j];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                yIndex = Integer.MAX_VALUE;
            }
            try {
                while (yIndex > xIndex) {
                    sum += (double)xValues[i] * (double)xValues[i];
                    xIndex = xIndexes[++i];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                xIndex = Integer.MAX_VALUE;
            }
        }
        return sum;
    }

    public GaussianRBFKernel(Properties props) {
        this(Float.parseFloat(props.getProperty("gamma")));
    }

    public GaussianRBFKernel(float gamma) {
        super(gamma);
    }

    public String toString() {
        return "RBF gamma=" + this.gamma;
    }

    public String toFileOutputString() {
        StringBuilder sb = new StringBuilder();
        sb.append("kernel_type rbf\n");
        sb.append("gamma " + this.gamma + "\n");
        return sb.toString();
    }

    @Override
    public double evaluate(SparseVector x, SparseVector y) {
        double sum = GaussianRBFKernel.explicitSumOptimized(x, y);
        double result = Math.exp(-this.gamma * sum);
        return result;
    }
}

