/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.binary;

import com.google.common.collect.Multiset;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblem;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationSVM;
import edu.berkeley.compbio.jlibsvm.binary.BinaryModel;
import edu.berkeley.compbio.jlibsvm.binary.BinarySolverNu;
import edu.berkeley.compbio.jlibsvm.qmatrix.BooleanInvertingKernelQMatrix;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nu_SVC<L extends Comparable, P>
extends BinaryClassificationSVM<L, P> {
    private static final Logger logger = Logger.getLogger(Nu_SVC.class);

    @Override
    public BinaryModel<L, P> trainOne(BinaryClassificationProblem<L, P> problem, float Cp, float Cn, @NotNull ImmutableSvmParameterPoint<L, P> param) {
        if (Cp != 1.0f || Cn != 1.0f) {
            logger.warn("Nu_SVC ignores Cp and Cn, provided values " + Cp + " and " + Cn + " + not used");
        }
        if (!this.isFeasible(problem, param)) {
            throw new SvmException("Nu_SVM is not feasible for this problem");
        }
        int l = problem.getNumExamples();
        float nu = param.nu;
        float sumPos = nu * (float)l / 2.0f;
        float sumNeg = nu * (float)l / 2.0f;
        Map<P, Boolean> examples = problem.getBooleanExamples();
        float linearTerm = 0.0f;
        ArrayList solutionVectors = new ArrayList();
        for (Map.Entry<P, Boolean> entry : examples.entrySet()) {
            float initAlpha;
            if (entry.getValue().booleanValue()) {
                initAlpha = Math.min(1.0f, sumPos);
                sumPos -= initAlpha;
            } else {
                initAlpha = Math.min(1.0f, sumNeg);
                sumNeg -= initAlpha;
            }
            SolutionVector<P> sv = new SolutionVector<P>(entry.getKey(), entry.getValue(), linearTerm, initAlpha);
            sv.id = problem.getId(entry.getKey());
            solutionVectors.add(sv);
        }
        BooleanInvertingKernelQMatrix qMatrix = new BooleanInvertingKernelQMatrix(param.kernel, problem.getNumExamples(), param.getCacheRows());
        BinarySolverNu s = new BinarySolverNu(solutionVectors, qMatrix, 1.0f, 1.0f, param.eps, param.shrinking);
        BinaryModel model = s.solve();
        model.param = param;
        model.trueLabel = problem.getTrueLabel();
        model.falseLabel = problem.getFalseLabel();
        model.setSvmType(this.getSvmType());
        float r = model.r;
        logger.info("C = " + 1.0f / r);
        for (Map.Entry entry : model.supportVectors.entrySet()) {
            entry.setValue((examples.get(entry.getKey()) != false ? 1.0 : -1.0) / (double)r);
        }
        model.rho /= r;
        model.obj /= r * r;
        model.upperBoundPositive = 1.0f / r;
        model.upperBoundNegative = 1.0f / r;
        model.compact();
        return model;
    }

    public boolean isFeasible(BinaryClassificationProblem problem, @NotNull ImmutableSvmParameter<L, P> param) {
        int n2;
        Multiset counts = problem.getExampleCounts();
        int n1 = counts.count(problem.getTrueLabel());
        return !(param.nu * (float)(n1 + (n2 = counts.count(problem.getFalseLabel()))) / 2.0f > (float)Math.min(n1, n2));
    }

    @Override
    public String getSvmType() {
        return "nu_svc";
    }

    @Override
    public void validateParam(@NotNull ImmutableSvmParameter<L, P> param) {
        super.validateParam(param);
        if (param.nu <= 0.0f || param.nu > 1.0f) {
            throw new SvmException("nu <= 0 or nu > 1");
        }
    }
}

