/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.binary;

import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblem;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationSVM;
import edu.berkeley.compbio.jlibsvm.binary.BinaryModel;
import edu.berkeley.compbio.jlibsvm.binary.BinarySolver;
import edu.berkeley.compbio.jlibsvm.qmatrix.BooleanInvertingKernelQMatrix;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C_SVC<L extends Comparable, P>
extends BinaryClassificationSVM<L, P> {
    private static final Logger logger = Logger.getLogger(C_SVC.class);

    @Override
    public BinaryModel<L, P> trainOne(BinaryClassificationProblem<L, P> problem, float Cp, float Cn, @NotNull ImmutableSvmParameterPoint<L, P> param) {
        float linearTerm = -1.0f;
        Map<P, Boolean> examples = problem.getBooleanExamples();
        ArrayList solutionVectors = new ArrayList(examples.size());
        for (Map.Entry<P, Boolean> example : examples.entrySet()) {
            SolutionVector<P> sv = new SolutionVector<P>(example.getKey(), example.getValue(), linearTerm);
            sv.id = problem.getId(example.getKey());
            solutionVectors.add(sv);
        }
        BooleanInvertingKernelQMatrix qMatrix = new BooleanInvertingKernelQMatrix(param.kernel, problem.getNumExamples(), param.getCacheRows());
        BinarySolver s = new BinarySolver(solutionVectors, qMatrix, Cp, Cn, param.eps, param.shrinking);
        BinaryModel model = s.solve();
        model.param = param;
        model.trueLabel = problem.getTrueLabel();
        model.falseLabel = problem.getFalseLabel();
        model.setSvmType(this.getSvmType());
        model.setScalingModel(problem.getScalingModel());
        if (Cp == Cn) {
            logger.debug("nu = " + model.getSumAlpha() / (Cp * (float)problem.getNumExamples()));
        }
        for (Map.Entry entry : model.supportVectors.entrySet()) {
            Object key = entry.getKey();
            Boolean target = examples.get(key);
            if (target.booleanValue()) continue;
            entry.setValue((Double)entry.getValue() * -1.0);
        }
        model.compact();
        return model;
    }

    @Override
    public String getSvmType() {
        return "c_svc";
    }

    @Override
    public void validateParam(@NotNull ImmutableSvmParameter<L, P> param) {
        super.validateParam(param);
        if (param instanceof ImmutableSvmParameterPoint && ((ImmutableSvmParameterPoint)param).C <= 0.0f) {
            throw new SvmException("C <= 0");
        }
    }
}

