/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.binary;

import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.Solver_NU;
import edu.berkeley.compbio.jlibsvm.binary.BinaryModel;
import edu.berkeley.compbio.jlibsvm.qmatrix.QMatrix;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySolverNu<L extends Comparable, P>
extends Solver_NU<L, P> {
    private static final Logger logger = Logger.getLogger(BinarySolverNu.class);

    public BinarySolverNu(List<SolutionVector<P>> solutionVectors, QMatrix<P> Q, float Cp, float Cn, float eps, boolean shrinking) {
        super(solutionVectors, Q, Cp, Cn, eps, shrinking);
    }

    public BinaryModel<L, P> solve() {
        int iter = this.optimize();
        BinaryModel model = new BinaryModel();
        this.calculate_rho(model);
        float v = 0.0f;
        for (SolutionVector svC : this.active) {
            v = (float)((double)v + svC.alpha * (svC.G + (double)svC.linearTerm));
        }
        model.obj = v / 2.0f;
        model.supportVectors = new HashMap();
        for (SolutionVector svC : this.allExamples) {
            model.supportVectors.put(svC.point, svC.alpha);
        }
        model.upperBoundPositive = this.Cp;
        model.upperBoundNegative = this.Cn;
        logger.info("optimization finished, #iter = " + iter);
        return model;
    }
}

