/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.binary.AlphaModel;
import edu.berkeley.compbio.jlibsvm.qmatrix.QMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Solver<L extends Comparable, P> {
    private static final Logger logger = Logger.getLogger(Solver.class);
    private static final int MAXITER = 50000;
    protected static final SolutionVector[] EMPTY_SV_ARRAY = new SolutionVector[0];
    QMatrix<P> Q;
    float[] Q_svA;
    float[] Q_svB;
    float[] Q_all;
    float eps;
    boolean unshrink = false;
    boolean shrinking;
    protected List<SolutionVector<P>> allExamples;
    protected SolutionVector<P>[] active;
    protected SolutionVector<P>[] inactive;
    protected float Cp;
    protected float Cn;
    protected int numExamples;

    protected Solver(QMatrix<P> Q, float Cp, float Cn, float eps, boolean shrinking) {
        if (eps <= 0.0f) {
            throw new SvmException("eps <= 0");
        }
        this.Q = Q;
        this.Cp = Cp;
        this.Cn = Cn;
        this.eps = eps;
        this.shrinking = shrinking;
    }

    public Solver(List<SolutionVector<P>> solutionVectors, QMatrix<P> Q, float Cp, float Cn, float eps, boolean shrinking) {
        this(Q, Cp, Cn, eps, shrinking);
        this.allExamples = solutionVectors;
        this.numExamples = this.allExamples.size();
        this.Q_all = new float[this.numExamples];
    }

    protected void calculate_rho(AlphaModel<L, P> si) {
        int nr_free = 0;
        double ub = Double.POSITIVE_INFINITY;
        double lb = Double.NEGATIVE_INFINITY;
        double sum_free = 0.0;
        for (SolutionVector<P> sv : this.active) {
            double yG = (double)(sv.targetValue ? 1.0f : -1.0f) * sv.G;
            if (sv.isLowerBound()) {
                if (sv.targetValue) {
                    ub = Math.min(ub, yG);
                    continue;
                }
                lb = Math.max(lb, yG);
                continue;
            }
            if (sv.isUpperBound()) {
                if (!sv.targetValue) {
                    ub = Math.min(ub, yG);
                    continue;
                }
                lb = Math.max(lb, yG);
                continue;
            }
            ++nr_free;
            sum_free += yG;
        }
        double r = nr_free > 0 ? sum_free / (double)nr_free : (ub + lb) / 2.0;
        si.rho = (float)r;
    }

    /*
     * Unable to fully structure code
     */
    protected int optimize() {
        this.Q.initRanks(this.allExamples);
        for (SolutionVector<P> svA : this.allExamples) {
            svA.updateAlphaStatus(this.Cp, this.Cn);
        }
        this.initActiveSet();
        for (SolutionVector<P> svA : this.allExamples) {
            svA.G = svA.linearTerm;
            svA.G_bar = 0.0f;
        }
        for (SolutionVector<P> svA : this.allExamples) {
            if (svA.isLowerBound()) continue;
            this.Q.getQ(svA, this.active, this.Q_svA);
            for (SolutionVector<P> svB : this.allExamples) {
                svB.G += svA.alpha * (double)this.Q_svA[svB.rank];
            }
            if (!svA.isUpperBound()) continue;
            for (SolutionVector<P> svB : this.allExamples) {
                svB.G_bar += svA.getC(this.Cp, this.Cn) * this.Q_svA[svB.rank];
            }
        }
        iter = 0;
        counter = Math.min(this.numExamples, 1000) + 1;
        block5: while (true) {
            if (--counter == 0) {
                counter = Math.min(this.numExamples, 1000);
                if (this.shrinking) {
                    this.do_shrinking();
                }
            }
            pair = this.selectWorkingPair();
            if (pair.isOptimal) {
                this.reconstruct_gradient();
                this.resetActiveSet();
                pair = this.selectWorkingPair();
                if (pair.isOptimal) break;
                counter = 1;
            }
            svA = pair.svA;
            svB = pair.svB;
            if (++iter > 50000) {
                Solver.logger.error("Solver reached maximum iterations, aborting");
                break;
            }
            this.Q.getQ(svA, this.active, this.Q_svA);
            this.Q.getQ(svB, this.active, this.Q_svB);
            C_i = svA.getC(this.Cp, this.Cn);
            C_j = svB.getC(this.Cp, this.Cn);
            old_alpha_i = svA.alpha;
            old_alpha_j = svB.alpha;
            if (svA.targetValue != svB.targetValue) {
                quad_coef = this.Q.evaluateDiagonal(svA) + this.Q.evaluateDiagonal(svB) + 2.0f * this.Q_svA[svB.rank];
                if (quad_coef <= 0.0f) {
                    quad_coef = 1.0E-12f;
                }
                delta = (-svA.G - svB.G) / (double)quad_coef;
                diff = svA.alpha - svB.alpha;
                svA.alpha += delta;
                svB.alpha += delta;
                if (diff > 0.0) {
                    if (svB.alpha < 0.0) {
                        svB.alpha = 0.0;
                        svA.alpha = diff;
                    }
                } else if (svA.alpha < 0.0) {
                    svA.alpha = 0.0;
                    svB.alpha = -diff;
                }
                if (diff > (double)(C_i - C_j)) {
                    if (svA.alpha > (double)C_i) {
                        svA.alpha = C_i;
                        svB.alpha = (double)C_i - diff;
                    }
                } else if (svB.alpha > (double)C_j) {
                    svB.alpha = C_j;
                    svA.alpha = (double)C_j + diff;
                }
            } else {
                quad_coef = this.Q.evaluateDiagonal(svA) + this.Q.evaluateDiagonal(svB) - 2.0f * this.Q_svA[svB.rank];
                if (quad_coef <= 0.0f) {
                    quad_coef = 1.0E-12f;
                }
                delta = (svA.G - svB.G) / (double)quad_coef;
                sum = svA.alpha + svB.alpha;
                svA.alpha -= delta;
                svB.alpha += delta;
                if (sum > (double)C_i) {
                    if (svA.alpha > (double)C_i) {
                        svA.alpha = C_i;
                        svB.alpha = sum - (double)C_i;
                    }
                } else if (svB.alpha < 0.0) {
                    svB.alpha = 0.0;
                    svA.alpha = sum;
                }
                if (sum > (double)C_j) {
                    if (svB.alpha > (double)C_j) {
                        svB.alpha = C_j;
                        svA.alpha = sum - (double)C_j;
                    }
                } else if (svA.alpha < 0.0) {
                    svA.alpha = 0.0;
                    svB.alpha = sum;
                }
            }
            delta_alpha_i = svA.alpha - old_alpha_i;
            delta_alpha_j = svB.alpha - old_alpha_j;
            if (delta_alpha_i == 0.0 && delta_alpha_j == 0.0) {
                Solver.logger.error("Pair is optimal within available numeric precision, but this is still larger than requested eps = " + this.eps + ".");
                break;
            }
            for (i = 0; i < this.active.length; ++i) {
                this.active[i].G += (double)this.Q_svA[i] * delta_alpha_i + (double)this.Q_svB[i] * delta_alpha_j;
            }
            ui = svA.isUpperBound();
            uj = svB.isUpperBound();
            svA.updateAlphaStatus(this.Cp, this.Cn);
            svB.updateAlphaStatus(this.Cp, this.Cn);
            if (ui != svA.isUpperBound()) {
                this.Q.getQ(svA, this.active, this.inactive, this.Q_all);
                if (ui) {
                    for (SolutionVector<P> svC : this.allExamples) {
                        svC.G_bar -= C_i * this.Q_all[svC.rank];
                    }
                } else {
                    for (SolutionVector<P> svC : this.allExamples) {
                        svC.G_bar += C_i * this.Q_all[svC.rank];
                    }
                }
            }
            if (uj == svB.isUpperBound()) continue;
            this.Q.getQ(svB, this.active, this.inactive, this.Q_all);
            if (uj) {
                i$ = this.allExamples.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block5;
                    svC = i$.next();
                    svC.G_bar -= C_j * this.Q_all[svC.rank];
                }
            }
            i$ = this.allExamples.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block5;
                svC = i$.next();
                svC.G_bar += C_j * this.Q_all[svC.rank];
            }
            break;
        }
        Solver.logger.debug(this.Q.perfString());
        Solver.logger.debug("optimization finished, #iter = " + iter);
        return iter;
    }

    protected void initActiveSet() {
        this.active = this.allExamples.toArray(EMPTY_SV_ARRAY);
        this.inactive = EMPTY_SV_ARRAY;
        this.Q_svA = new float[this.active.length];
        this.Q_svB = new float[this.active.length];
    }

    void do_shrinking() {
        double Gmax1 = Double.NEGATIVE_INFINITY;
        double Gmax2 = Double.NEGATIVE_INFINITY;
        for (SolutionVector<P> solutionVector : this.active) {
            if (solutionVector.targetValue) {
                if (!solutionVector.isUpperBound() && -solutionVector.G >= Gmax1) {
                    Gmax1 = -solutionVector.G;
                }
                if (solutionVector.isLowerBound() || !(solutionVector.G >= Gmax2)) continue;
                Gmax2 = solutionVector.G;
                continue;
            }
            if (!solutionVector.isUpperBound() && -solutionVector.G >= Gmax2) {
                Gmax2 = -solutionVector.G;
            }
            if (solutionVector.isLowerBound() || !(solutionVector.G >= Gmax1)) continue;
            Gmax1 = solutionVector.G;
        }
        if (!this.unshrink && Gmax1 + Gmax2 <= (double)(this.eps * 10.0f)) {
            this.unshrink = true;
            this.reconstruct_gradient();
            this.resetActiveSet();
        }
        ArrayList<SolutionVector<P>> activeList = new ArrayList<SolutionVector<P>>(Arrays.asList(this.active));
        ArrayList<SolutionVector<P>> inactiveList = new ArrayList<SolutionVector<P>>(this.inactive.length);
        Iterator iter = activeList.iterator();
        while (iter.hasNext()) {
            SolutionVector solutionVector = (SolutionVector)iter.next();
            if (!solutionVector.isShrinkable(Gmax1, Gmax2)) continue;
            iter.remove();
            inactiveList.add(solutionVector);
        }
        this.active = activeList.toArray(EMPTY_SV_ARRAY);
        this.Q_svA = new float[this.active.length];
        this.Q_svB = new float[this.active.length];
        SolutionVector[] newlyInactive = inactiveList.toArray(EMPTY_SV_ARRAY);
        this.Q.maintainCache(this.active, newlyInactive);
        inactiveList.addAll(Arrays.asList(this.inactive));
        this.inactive = inactiveList.toArray(EMPTY_SV_ARRAY);
        Arrays.sort(this.active);
        Arrays.sort(this.inactive);
    }

    void reconstruct_gradient() {
        if (this.active.length == this.numExamples) {
            return;
        }
        int nr_free = 0;
        for (SolutionVector<P> sv : this.inactive) {
            sv.G = sv.G_bar + sv.linearTerm;
        }
        for (SolutionVector<P> sv : this.active) {
            if (!sv.isFree()) continue;
            ++nr_free;
        }
        int activeSize = this.active.length;
        if (nr_free * this.numExamples > 2 * activeSize * (this.numExamples - activeSize)) {
            for (SolutionVector<P> svA : this.inactive) {
                this.Q.getQ(svA, this.active, this.Q_svA);
                for (SolutionVector<P> svB : this.active) {
                    if (!svB.isFree()) continue;
                    svA.G += svB.alpha * (double)this.Q_svA[svB.rank];
                }
            }
        } else {
            for (SolutionVector<P> svA : this.active) {
                if (!svA.isFree()) continue;
                this.Q.getQ(svA, this.active, this.inactive, this.Q_all);
                for (SolutionVector<P> svB : this.inactive) {
                    svB.G += svA.alpha * (double)this.Q_all[svB.rank];
                }
            }
        }
    }

    protected void resetActiveSet() {
        this.active = this.allExamples.toArray(EMPTY_SV_ARRAY);
        Arrays.sort(this.active);
        this.inactive = EMPTY_SV_ARRAY;
        this.Q_svA = new float[this.active.length];
        this.Q_svB = new float[this.active.length];
    }

    protected SolutionVectorPair selectWorkingPair() {
        SolutionVector<P> sv;
        int i;
        double Gmax = Double.NEGATIVE_INFINITY;
        double Gmax2 = Double.NEGATIVE_INFINITY;
        SolutionVector<P> GmaxSV = null;
        SolutionVector<P> GminSV = null;
        double obj_diff_min = Double.POSITIVE_INFINITY;
        int l = this.active.length;
        for (i = 0; i < l; ++i) {
            sv = this.active[i];
            if (sv.targetValue) {
                if (sv.isUpperBound() || !(-sv.G >= Gmax)) continue;
                Gmax = -sv.G;
                GmaxSV = sv;
                continue;
            }
            if (sv.isLowerBound() || !(sv.G >= Gmax)) continue;
            Gmax = sv.G;
            GmaxSV = sv;
        }
        if (GmaxSV != null) {
            this.Q.getQ(GmaxSV, this.active, this.Q_svA);
        }
        for (i = 0; i < l; ++i) {
            double quad_coef;
            double obj_diff;
            double grad_diff;
            sv = this.active[i];
            if (sv.targetValue) {
                if (sv.isLowerBound()) continue;
                grad_diff = Gmax + sv.G;
                if (sv.G >= Gmax2) {
                    Gmax2 = sv.G;
                }
                if (!(grad_diff > 0.0) || !((obj_diff = (quad_coef = (double)(this.Q.evaluateDiagonal(GmaxSV) + this.Q.evaluateDiagonal(sv) - 2.0f * (GmaxSV.targetValue ? 1.0f : -1.0f) * this.Q_svA[sv.rank])) > 0.0 ? -(grad_diff * grad_diff) / quad_coef : -(grad_diff * grad_diff) / (double)1.0E-12f) <= obj_diff_min)) continue;
                GminSV = sv;
                obj_diff_min = obj_diff;
                continue;
            }
            if (sv.isUpperBound()) continue;
            grad_diff = Gmax - sv.G;
            if (-sv.G >= Gmax2) {
                Gmax2 = -sv.G;
            }
            if (!(grad_diff > 0.0) || !((obj_diff = (quad_coef = (double)(this.Q.evaluateDiagonal(GmaxSV) + this.Q.evaluateDiagonal(sv) + 2.0f * (GmaxSV.targetValue ? 1.0f : -1.0f) * this.Q_svA[sv.rank])) > 0.0 ? -(grad_diff * grad_diff) / quad_coef : -(grad_diff * grad_diff) / (double)1.0E-12f) <= obj_diff_min)) continue;
            GminSV = sv;
            obj_diff_min = obj_diff;
        }
        return new SolutionVectorPair(GmaxSV, GminSV, Gmax + Gmax2 < (double)this.eps);
    }

    protected class SolutionVectorPair {
        boolean isOptimal;
        SolutionVector svA;
        SolutionVector svB;

        protected SolutionVectorPair(SolutionVector svA, SolutionVector svB, boolean isOptimal) {
            this.svA = svA;
            this.svB = svB;
            this.isOptimal = isOptimal;
        }
    }
}

