/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.kernel.KernelFunction;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableSvmParameterGrid<L extends Comparable, P>
extends ImmutableSvmParameter<L, P> {
    private final Collection<ImmutableSvmParameterPoint<L, P>> gridParams;

    public ImmutableSvmParameterGrid(Builder<L, P> copyFrom) {
        super(copyFrom);
        this.gridParams = ((Builder)copyFrom).gridParams;
    }

    public Collection<ImmutableSvmParameterPoint<L, P>> getGridParams() {
        return this.gridParams;
    }

    public static <L extends Comparable, P> Builder<L, P> builder() {
        return new Builder();
    }

    @Override
    public Builder<L, P> asBuilder() {
        return new Builder(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<L extends Comparable, P>
    extends ImmutableSvmParameter.Builder {
        public Collection<Float> Cset;
        public Collection<KernelFunction<P>> kernelSet;
        private Collection<ImmutableSvmParameterPoint<L, P>> gridParams;

        public Builder(ImmutableSvmParameter.Builder copyFrom) {
            super(copyFrom);
            this.Cset = new HashSet<Float>();
            this.Cset.add(Float.valueOf(1.0f));
        }

        public Builder(ImmutableSvmParameterGrid<L, P> copyFrom) {
            super(copyFrom);
            this.gridParams = ((ImmutableSvmParameterGrid)copyFrom).gridParams;
        }

        public Builder() {
        }

        @Override
        public ImmutableSvmParameter<L, P> build() {
            ImmutableSvmParameterPoint.Builder builder = ImmutableSvmParameterPoint.asBuilder(this);
            if (this.Cset == null || this.Cset.isEmpty()) {
                throw new SvmException("Can't build a grid with no C values");
            }
            if (this.kernelSet == null || this.kernelSet.isEmpty()) {
                throw new SvmException("Can't build a grid with no kernels");
            }
            if (this.Cset.size() == 1 && this.kernelSet.size() == 1) {
                builder.C = this.Cset.iterator().next().floatValue();
                builder.kernel = this.kernelSet.iterator().next();
                return builder.build();
            }
            this.gridParams = new HashSet<ImmutableSvmParameterPoint<L, P>>();
            for (Float gridC : this.Cset) {
                for (KernelFunction<P> gridKernel : this.kernelSet) {
                    builder.C = gridC.floatValue();
                    builder.kernel = gridKernel;
                    builder.gridsearchBinaryMachinesIndependently = false;
                    this.gridParams.add((ImmutableSvmParameterPoint<L, P>)builder.build());
                }
            }
            return new ImmutableSvmParameterGrid(this);
        }
    }
}

