/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees.htpn;

import com.davidsoergel.dsutils.DSStringUtils;
import com.davidsoergel.dsutils.collections.OrderedPair;
import com.davidsoergel.trees.AbstractHierarchyNode;
import com.davidsoergel.trees.htpn.BasicHierarchicalTypedPropertyNode;
import com.davidsoergel.trees.htpn.HierarchicalTypedPropertyNode;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHierarchicalTypedPropertyNode<K extends Comparable, V, H extends HierarchicalTypedPropertyNode<K, V, H>>
extends AbstractHierarchyNode<OrderedPair<K, V>, H>
implements HierarchicalTypedPropertyNode<K, V, H> {
    private static final Logger logger = Logger.getLogger(BasicHierarchicalTypedPropertyNode.class);
    protected Type type;
    protected Map<K, H> childrenByName = new TreeMap<K, H>();
    private K[] keyPath;

    @Override
    public K getKey() {
        return (K)(this.payload == null ? null : (Comparable)((OrderedPair)this.payload).getKey1());
    }

    @Override
    public void setKey(K newKey) {
        this.payload = new OrderedPair<K, V>(newKey, this.getValue());
        this.keyPath = null;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type type2) {
        this.type = type2;
    }

    @Override
    public V getValue() {
        return this.payload == null ? null : (V)((OrderedPair)this.payload).getKey2();
    }

    public String toString() {
        try {
            return "HierarchicalTypedPropertyNode -> keyPath = " + DSStringUtils.join((Object[])this.getKeyPath(), ".") + ", type = " + this.type + ", value = " + this.getValue();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "broken";
        }
    }

    public int compareTo(Object o) {
        K key = this.getKey();
        if (o == null) {
            return -1;
        }
        if (this.equals(o)) {
            return 0;
        }
        if (key == null) {
            return -1;
        }
        return key.compareTo(((HierarchicalTypedPropertyNode)o).getKey());
    }

    @Override
    public void addChild(K childKey, V childValue) {
        this.updateOrCreateChild(childKey, childValue);
    }

    @Override
    public void addChild(K[] childKeyPath, V childValue) {
        this.getOrCreateDescendant((Comparable[])childKeyPath).setValue(childValue);
    }

    @Override
    public void addChild(K[] childKeyPath, K leafKey, V childValue) {
        this.getOrCreateDescendant((Comparable[])childKeyPath).updateOrCreateChild(leafKey, childValue);
    }

    @Override
    public void collectDescendants(Map<K[], HierarchicalTypedPropertyNode<K, V, H>> result) {
        result.put((Comparable[][])this.getKeyPath(), this);
        for (HierarchicalTypedPropertyNode child : this.childrenByName.values()) {
            child.collectDescendants(result);
        }
    }

    @Override
    public Map<K[], HierarchicalTypedPropertyNode<K, V, H>> getAllDescendants() {
        HashMap<K[], HierarchicalTypedPropertyNode<K, V, H>> result = new HashMap<K[], HierarchicalTypedPropertyNode<K, V, H>>();
        this.collectDescendants(result);
        return result;
    }

    @Override
    @NotNull
    public Collection<H> getChildNodes() {
        return this.childrenByName.values();
    }

    @Override
    public Object[] getEnumOptions() {
        try {
            return ((Class)this.type).getEnumConstants();
        }
        catch (ClassCastException e) {
            throw new Error("Can't get enum options for a field of generic type.");
        }
    }

    @Override
    public V getInheritedValue(K forKey) {
        V result = this.getChildValue(forKey);
        if ((result == null || result.equals((Object)HierarchicalTypedPropertyNode.PropertyConsumerFlags.INHERITED)) && this.parent != null) {
            result = ((HierarchicalTypedPropertyNode)this.parent).getInheritedValue(forKey);
        }
        return result;
    }

    @Override
    public HierarchicalTypedPropertyNode<K, V, H> getInheritedNode(K forKey) {
        Object result = this.getChild(forKey);
        if ((result == null || result.getValue().equals((Object)HierarchicalTypedPropertyNode.PropertyConsumerFlags.INHERITED)) && this.parent != null) {
            result = ((HierarchicalTypedPropertyNode)this.parent).getInheritedNode(forKey);
        }
        return result;
    }

    @Override
    public H getOrCreateDescendant(K[] keyPath) {
        AbstractHierarchicalTypedPropertyNode<K, V, H> trav = this;
        for (K childKey : keyPath) {
            trav = trav.getOrCreateChild(childKey);
        }
        return (H)trav;
    }

    @Override
    public void inheritValueIfNeeded() {
        V value = this.getValue();
        if (value == HierarchicalTypedPropertyNode.PropertyConsumerFlags.INHERITED) {
            this.setValue(((HierarchicalTypedPropertyNode)this.getParent()).getInheritedValue(this.getKey()));
            if (this.isClassBoundPlugin()) {
                logger.warn("Plugin definition inherited: " + this.getKey() + "=" + this.getValue() + " (singleton only if get/setInjectedInstance exists, else newly instantiated)");
                this.copyFrom(((HierarchicalTypedPropertyNode)this.getParent()).getInheritedNode(this.getKey()));
            }
        }
    }

    @Override
    public boolean isClassBoundPlugin() {
        return this.getValue() instanceof Class;
    }

    @Override
    public K[] getKeyPath() {
        if (this.keyPath == null) {
            LinkedList<Comparable> result = new LinkedList<Comparable>();
            for (AbstractHierarchicalTypedPropertyNode<K, V, H> trav = this; trav != null; trav = trav.getParent()) {
                OrderedPair payload = (OrderedPair)trav.getPayload();
                result.add(0, payload == null ? null : (Comparable)payload.getKey1());
            }
            this.keyPath = result.toArray(new Comparable[0]);
        }
        return this.keyPath;
    }

    @Override
    public void setPayload(OrderedPair<K, V> payload) {
        super.setPayload(payload);
        this.keyPath = null;
    }

    @Override
    public void removeChild(K childKey) {
        this.childrenByName.remove(childKey);
    }

    @Override
    public void setValue(V value) {
        this.payload = new OrderedPair<K, V>(this.getKey(), value);
        if (this.isClassBoundPlugin() && value != null) {
            throw new Error("Can't set a plugin value on a regular HTPN; need to use the StringNamed version");
        }
    }

    public void clearChildren() {
        this.childrenByName = new TreeMap<K, H>();
    }

    public V getChildValue(K childKey) {
        H child = this.getChild(childKey);
        if (child == null) {
            return null;
        }
        return (V)((OrderedPair)child.getPayload()).getKey2();
    }

    public H getChild(K childKey) {
        return (H)((HierarchicalTypedPropertyNode)this.childrenByName.get(childKey));
    }

    @Override
    @NotNull
    public Collection<H> getChildren() {
        return this.childrenByName.values();
    }

    public void addChild(@NotNull H n) {
        assert (n.getKey() != null);
        this.childrenByName.put(n.getKey(), n);
    }

    @Override
    public void registerChild(H a) {
        assert (a.getKey() != null);
        this.childrenByName.put(a.getKey(), a);
    }

    @Override
    public void unregisterChild(H a) {
        Object key = a.getKey();
        if (((HierarchicalTypedPropertyNode)this.childrenByName.get(key)).equals(a)) {
            this.childrenByName.remove(key);
        }
    }

    @Override
    public H getOrCreateChild(K childKey) {
        Object child = this.getChild(childKey);
        if (child == null) {
            child = (HierarchicalTypedPropertyNode)this.newChild(new OrderedPair<K, Object>(childKey, null));
        }
        return child;
    }

    @Override
    public H updateOrCreateChild(K childKey, V childValue) {
        Object child = this.getChild(childKey);
        if (child == null) {
            child = (HierarchicalTypedPropertyNode)this.newChild(new OrderedPair<K, V>(childKey, childValue));
            child.setValue(childValue);
        }
        child.updateTypeIfNeeded(childValue);
        return child;
    }

    @Override
    public void updateTypeIfNeeded(V v) {
        if (this.getType() == null && v != null) {
            this.setType(v.getClass());
        }
    }

    @Override
    public void copyFrom(HierarchicalTypedPropertyNode<K, V, ?> node) {
        this.setType(node.getType());
        this.clearChildren();
        for (HierarchicalTypedPropertyNode child : node.getChildNodes()) {
            ((HierarchicalTypedPropertyNode)this.newChild(child.getPayload())).copyFrom(child);
        }
    }
}

