/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees.htpn;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.DSClassUtils;
import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.PluginManager;
import com.davidsoergel.dsutils.TypeUtils;
import com.davidsoergel.dsutils.collections.OrderedPair;
import com.davidsoergel.dsutils.increment.Incrementor;
import com.davidsoergel.dsutils.stringmapper.StringMapperException;
import com.davidsoergel.dsutils.stringmapper.TypedValueStringMapper;
import com.davidsoergel.trees.htpn.AbstractHierarchicalTypedPropertyNode;
import com.davidsoergel.trees.htpn.ExtendedHierarchicalTypedPropertyNode;
import com.davidsoergel.trees.htpn.HierarchicalPropertyNodeException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtendedHierarchicalTypedPropertyNode<K extends Comparable, V, H extends ExtendedHierarchicalTypedPropertyNode<K, V, H>>
extends AbstractHierarchicalTypedPropertyNode<K, V, H>
implements ExtendedHierarchicalTypedPropertyNode<K, V, H> {
    private static final Logger logger = Logger.getLogger(AbstractExtendedHierarchicalTypedPropertyNode.class);
    protected V defaultValue;
    private String helpmessage;
    private boolean isNullable = false;
    protected boolean editable = true;
    private boolean obsolete = false;
    private boolean changed = false;

    @Override
    public void copyFrom(ExtendedHierarchicalTypedPropertyNode<K, V, ?> node) {
        this.setType(node.getType());
        try {
            this.setDefaultAndNullable(node.getDefaultValue(), node.isNullable());
        }
        catch (HierarchicalPropertyNodeException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
        this.helpmessage = node.getHelpmessage();
        this.editable = node.isEditable();
        this.obsolete = node.isObsolete();
        this.changed = node.isChanged();
        this.clearChildren();
        for (ExtendedHierarchicalTypedPropertyNode child : node.getChildNodes()) {
            ((ExtendedHierarchicalTypedPropertyNode)this.newChild(child.getPayload())).copyFrom(child);
        }
    }

    @Override
    public void setDefaultAndNullable(V defaultValue, boolean isNullable) throws HierarchicalPropertyNodeException {
        if (this.type == null) {
            this.isNullable = true;
        } else {
            this.defaultValue = defaultValue;
            this.isNullable = isNullable;
            this.useDefaultValueIfNeeded();
            this.defaultValueSanityChecks();
        }
    }

    @Override
    public V getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getHelpmessage() {
        return this.helpmessage;
    }

    @Override
    public void setHelpmessage(String helpmessage) {
        this.helpmessage = helpmessage;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }

    @Override
    public void obsoleteChildren() {
        for (ExtendedHierarchicalTypedPropertyNode child : this.childrenByName.values()) {
            child.setObsolete(true);
        }
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
        for (ExtendedHierarchicalTypedPropertyNode child : this.childrenByName.values()) {
            child.setChanged(changed);
        }
    }

    @Override
    public SortedSet<Class> getPluginOptions(Incrementor incrementor) {
        Object value = this.getValue();
        if (value != null && !(value instanceof GenericFactory) && !(value instanceof Class)) {
            logger.warn("Can't get plugin options for a value " + value + " of type " + value.getClass());
        }
        Type thePluginType = this.type;
        if (TypeUtils.isAssignableFrom(GenericFactory.class, this.type)) {
            thePluginType = this.type instanceof Class ? this.type : ((ParameterizedType)this.type).getActualTypeArguments()[0];
        }
        TreeSet<Class> result = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        if (this.isNullable) {
            result.add(null);
        }
        try {
            PluginManager.registerPluginsFromDefaultPackages(thePluginType, incrementor);
        }
        catch (IOException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
        result.addAll(PluginManager.getPlugins(thePluginType));
        return result;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isObsolete() {
        return this.obsolete || this.parent != null && ((ExtendedHierarchicalTypedPropertyNode)this.parent).isObsolete();
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    protected boolean valueEquals(V newValue) {
        Object value = this.getValue();
        if (value == null && newValue == null) {
            return true;
        }
        return value != null && value.equals(newValue);
    }

    @Override
    public void setValue(V newValue) {
        if (!this.valueEquals(newValue)) {
            this.obsoleteChildren();
            this.payload = new OrderedPair(this.getKey(), newValue);
            Object value = this.getValue();
            this.updateTypeIfNeeded(value);
            this.setChanged(true);
        }
    }

    @Override
    public void defaultValueSanityChecks() throws HierarchicalPropertyNodeException {
        if (this.defaultValue == null) {
            if (!this.isNullable) {
                logger.error("Node is not nullable and has no default value: " + this);
                throw new HierarchicalPropertyNodeException("Node is not nullable and has no default value: " + this);
            }
        } else if (!this.defaultValue.getClass().equals(Class.class)) {
            if (!(this.type instanceof Class)) {
                throw new HierarchicalPropertyNodeException("Node has generic type, but the default value is not a plugin class");
            }
            if (!(this.type instanceof Class && ((Class)this.type).isPrimitive() && DSClassUtils.isAssignable(this.defaultValue.getClass(), DSClassUtils.primitiveToWrapper((Class)this.type)) || TypeUtils.isAssignableFrom(this.type, this.defaultValue.getClass()))) {
                throw new HierarchicalPropertyNodeException("Can't assign a default value of type " + this.defaultValue.getClass() + " to a node requiring " + this.type);
            }
        }
    }

    @Override
    public void useDefaultValueIfNeeded() throws HierarchicalPropertyNodeException {
        if (this.getValue() == null && !this.isNullable) {
            this.setValue(this.defaultValue);
        }
    }

    @Override
    public H updateOrCreateChild(K childKey, V childValue) {
        ExtendedHierarchicalTypedPropertyNode child = (ExtendedHierarchicalTypedPropertyNode)this.getChild(childKey);
        if (child == null) {
            child = (ExtendedHierarchicalTypedPropertyNode)this.newChild(new OrderedPair<K, V>(childKey, childValue));
            child.updateTypeIfNeeded(childValue);
            child.setObsolete(true);
            child.obsoleteChildren();
        }
        return (H)child;
    }

    @Override
    public void removeObsoletes() {
        HashSet set = new HashSet(this.getChildNodes());
        for (ExtendedHierarchicalTypedPropertyNode n : set) {
            if (n.isObsolete()) {
                this.removeChild(n.getKey());
                continue;
            }
            n.removeObsoletes();
        }
    }

    @Override
    public void appendToStringBuffer(StringBuffer sb, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append(this.getKey()).append(" = ").append(this.getValue()).append("\n");
        ++indentLevel;
        for (ExtendedHierarchicalTypedPropertyNode child : this.childrenByName.values()) {
            child.appendToStringBuffer(sb, indentLevel);
        }
    }

    public int getTotalRuns() {
        throw new NotImplementedException();
    }

    public void setValueFromString(String string) throws HierarchicalPropertyNodeException {
        try {
            this.setValue(TypedValueStringMapper.get(this.getType()).parse(string));
        }
        catch (StringMapperException e) {
            logger.error("Error", e);
            throw new HierarchicalPropertyNodeException(e);
        }
    }

    public V getValueForDescendant(K[] keyList) {
        ExtendedHierarchicalTypedPropertyNode desc = this.getDescendant((Comparable[])keyList);
        return desc == null ? null : (V)desc.getValue();
    }

    public ExtendedHierarchicalTypedPropertyNode<K, V, H> getDescendant(K[] keyList) {
        AbstractExtendedHierarchicalTypedPropertyNode<K, V, H> trav = this;
        for (K k : keyList) {
            if ((trav = trav.getChild(k)) != null) continue;
            return null;
        }
        return trav;
    }

    public boolean isPlottable() {
        Object o = this.getValue();
        return o instanceof Number || DSArrayUtils.isNumberArray(o) || DSArrayUtils.isPrimitiveArray(o);
    }
}

