/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.trees.NodeNamer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringNodeNamer
implements NodeNamer<String> {
    protected boolean allowNull = false;
    private String unknownBasis;
    private int currentId = 0;
    boolean requireGeneratedNamesForInternalNodes = false;
    Map<String, Integer> uniqueIndexes = new HashMap<String, Integer>();

    public StringNodeNamer(String unknownBasis, boolean allowNull, boolean requireGeneratedNamesForInternalNodes) {
        this.unknownBasis = unknownBasis;
        this.allowNull = allowNull;
        this.requireGeneratedNamesForInternalNodes = requireGeneratedNamesForInternalNodes;
    }

    public StringNodeNamer(String unknownBasis, boolean allowNull, boolean requireGeneratedNamesForInternalNodes, int startId) {
        this(unknownBasis, allowNull, requireGeneratedNamesForInternalNodes);
        this.currentId = startId;
    }

    @Override
    public boolean requireGeneratedNamesForInternalNodes() {
        return this.requireGeneratedNamesForInternalNodes;
    }

    @Override
    public String create(Integer s) {
        return s.toString();
    }

    @Override
    public String create(String s) {
        return s;
    }

    @Override
    public String merge(String name, String s) {
        return name + s;
    }

    @Override
    public String merge(String name, Integer s) {
        return name + s;
    }

    @Override
    public String generate() {
        if (this.unknownBasis == null) {
            return null;
        }
        return this.unknownBasis + this.currentId++;
    }

    @Override
    public String uniqueify(String value) {
        if (value == null && this.allowNull) {
            return null;
        }
        Integer inc = this.uniqueIndexes.get(value);
        if (inc == null) {
            inc = 0;
        }
        Integer n = inc;
        Integer n2 = inc = Integer.valueOf(inc + 1);
        this.uniqueIndexes.put(value, inc);
        return value + " " + inc;
    }

    @Override
    public boolean isAcceptable(String value) {
        return this.allowNull || value != null;
    }

    @Override
    public String makeAggregate(String newValue, String value) {
        if (value == null) {
            return newValue;
        }
        return newValue + "==" + value;
    }
}

