/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.trees.AbstractHierarchyNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetHierarchyNode<T extends Serializable>
extends AbstractHierarchyNode<T, SetHierarchyNode<T>>
implements Serializable {
    protected Set<SetHierarchyNode<T>> children = new HashSet<SetHierarchyNode<T>>();

    public SetHierarchyNode(T contents) {
        super(contents);
    }

    public SetHierarchyNode() {
    }

    @Override
    public void registerChild(SetHierarchyNode<T> child) {
        this.children.add(child);
    }

    @Override
    public void unregisterChild(SetHierarchyNode<T> child) {
        this.children.remove(child);
    }

    @Override
    public Set<SetHierarchyNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public SetHierarchyNode<T> newChild(T payload) {
        SetHierarchyNode<T> result = new SetHierarchyNode<T>();
        result.setPayload(payload);
        result.setParent(this);
        return result;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.payload = (Serializable)stream.readObject();
        this.children = (Set)stream.readObject();
        for (SetHierarchyNode<T> child : this.children) {
            child.setParent(this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.payload);
        stream.writeObject(this.children);
    }
}

