/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.stats.ContinuousDistribution1D;
import com.davidsoergel.trees.BasicRootedPhylogeny;
import com.davidsoergel.trees.NoSuchNodeException;
import com.davidsoergel.trees.NodeNamer;
import com.davidsoergel.trees.PhylogenyNode;
import com.davidsoergel.trees.SerializableRootedPhylogeny;
import com.davidsoergel.trees.TaxonMergingPhylogeny;
import com.davidsoergel.trees.TreeException;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RootedPhylogeny<T extends Serializable>
extends PhylogenyNode<T>,
TaxonMergingPhylogeny<T> {
    @Nullable
    public T commonAncestor(Collection<T> var1) throws NoSuchNodeException;

    @Nullable
    public T commonAncestor(Collection<T> var1, double var2) throws NoSuchNodeException;

    @Nullable
    public T commonAncestor(T var1, T var2) throws NoSuchNodeException;

    public boolean isDescendant(T var1, T var2);

    public Set<T> selectAncestors(Collection<T> var1, T var2);

    public boolean isDescendant(PhylogenyNode<T> var1, PhylogenyNode<T> var2);

    public double distanceBetween(T var1, T var2) throws NoSuchNodeException;

    public double distanceBetween(PhylogenyNode<T> var1, PhylogenyNode<T> var2) throws NoSuchNodeException;

    @NotNull
    public PhylogenyNode<T> getNode(T var1) throws NoSuchNodeException;

    public double getWeight(T var1) throws NoSuchNodeException;

    public PhylogenyNode<T> getRoot();

    public Map<T, ? extends PhylogenyNode<T>> getUniqueIdToNodeMap();

    public Collection<PhylogenyNode<T>> getLeaves();

    public T nearestKnownAncestor(RootedPhylogeny<T> var1, T var2) throws NoSuchNodeException;

    public Set<T> getLeafValues();

    public Set<T> getNodeValues();

    public double getTotalBranchLength();

    public void randomizeLeafWeights(ContinuousDistribution1D var1);

    public void uniformizeLeafWeights() throws TreeException;

    public void normalizeWeights() throws TreeException;

    @Nullable
    public RootedPhylogeny<T> getBasePhylogeny();

    @NotNull
    public RootedPhylogeny<T> getBasePhylogenyRecursive();

    public SerializableRootedPhylogeny<T> extractIntersectionTree(Collection<T> var1, Collection<T> var2, NodeNamer<T> var3) throws TreeException, NoSuchNodeException;

    public BasicRootedPhylogeny<T> mixWith(RootedPhylogeny<T> var1, double var2) throws TreeException;

    public void smoothWeightsFrom(RootedPhylogeny<T> var1, double var2) throws NoSuchNodeException, TreeException;

    @Override
    public RootedPhylogeny<T> clone();

    public void setLeafWeights(Multiset<T> var1) throws TreeException;

    public void setLeafWeights(Map<T, Double> var1) throws TreeException;

    public Map<T, Double> getLeafWeights() throws TreeException;

    public Map<T, Double> getNodeWeights() throws TreeException;

    public void setAllBranchLengthsTo(Double var1);

    public Map<T, Double> distributeInternalWeightsToLeaves(Map<T, Double> var1) throws NoSuchNodeException;

    public T getShallowestLeaf();

    public PhylogenyNode<T> getFirstBranchingNode();

    public T getLeafAtApproximateDistance(T var1, double var2, double var4) throws NoSuchNodeException;
}

