/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.trees.DepthFirstTreeIterator;
import com.davidsoergel.trees.HierarchyNode;
import com.davidsoergel.trees.TreeException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepthFirstTreeIteratorImpl<T, I extends HierarchyNode<T, I>>
implements DepthFirstTreeIterator<T, I> {
    I root;
    Iterator<? extends HierarchyNode<T, I>> breadthIterator = null;
    DepthFirstTreeIterator<T, I> subtreeIterator = null;

    public DepthFirstTreeIteratorImpl(I root) {
        this.root = root;
    }

    @Override
    public boolean hasNext() {
        return this.breadthIterator == null || this.subtreeIterator != null && this.subtreeIterator.hasNext() || this.breadthIterator.hasNext();
    }

    @Override
    public I next() {
        if (this.breadthIterator == null) {
            this.breadthIterator = this.root.getChildren().iterator();
            if (this.breadthIterator.hasNext()) {
                this.subtreeIterator = this.breadthIterator.next().depthFirstIterator();
            }
            return this.root;
        }
        if (this.subtreeIterator == null) {
            return null;
        }
        if (this.subtreeIterator.hasNext()) {
            return (I)((HierarchyNode)this.subtreeIterator.next());
        }
        if (this.breadthIterator.hasNext()) {
            this.subtreeIterator = this.breadthIterator.next().depthFirstIterator();
            return (I)((HierarchyNode)this.subtreeIterator.next());
        }
        return null;
    }

    @Override
    public void skipAllDescendants(HierarchyNode<T, I> node) throws TreeException {
        if (node == this.root) {
            if (this.breadthIterator == null) {
                throw new TreeException("Can't skip descendants of a node that hasn't been returned yet");
            }
            this.subtreeIterator = null;
            while (this.breadthIterator.hasNext()) {
                this.breadthIterator.next();
            }
        } else if (this.subtreeIterator != null) {
            this.subtreeIterator.skipAllDescendants(node);
        } else {
            throw new TreeException("Can't skip descendants of a node that is not on the current path");
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

