/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.stats.DoubleArrayContainer;
import com.davidsoergel.stats.StatsException;

public class PearsonCorrelation {
    public static double computeCorrelationCoefficient(DoubleArrayContainer x, DoubleArrayContainer y) throws StatsException {
        return PearsonCorrelation.computeCorrelationCoefficient(x.getArray(), y.getArray());
    }

    public static double computeCorrelationCoefficient(double[] x, double[] y) throws StatsException {
        double pop_sd_y;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        double mean_x = x[1];
        double mean_y = y[1];
        int n = x.length;
        if (y.length != n) {
            throw new StatsException("Cannot compute correlation coefficient between arrays of different lengths");
        }
        for (int i = 2; i < n; ++i) {
            double sweep = ((double)i - 1.0) / (double)i;
            double delta_x = x[i] - mean_x;
            double delta_y = y[i] - mean_y;
            if (Double.isNaN(delta_x) || Double.isInfinite(delta_x)) {
                throw new StatsException("Error computing Pearson correlation: NaN or Infinity");
            }
            if (Double.isNaN(delta_y) || Double.isInfinite(delta_y)) {
                throw new StatsException("Error computing Pearson correlation: NaN or Infinity");
            }
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (double)i;
            mean_y += delta_y / (double)i;
        }
        if (sum_sq_x == 0.0 || sum_sq_y == 0.0) {
            throw new StatsException("Can't compute Pearson correlation: distribution has no variance");
        }
        double cov_x_y = sum_coproduct / (double)n;
        double pop_sd_x = Math.sqrt(sum_sq_x / (double)n);
        double correlation = cov_x_y / (pop_sd_x * (pop_sd_y = Math.sqrt(sum_sq_y / (double)n)));
        if (Double.isNaN(correlation) || Double.isInfinite(correlation)) {
            throw new StatsException("Error computing Pearson correlation: NaN or Infinity");
        }
        return correlation;
    }

    public static double computeCorrelationCoefficient(double[] x, double[] y, double ignore) throws StatsException {
        double pop_sd_y;
        int n = x.length;
        if (y.length != n) {
            throw new StatsException("Cannot compute correlation coefficient between arrays of different lengths");
        }
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        int startI = 1;
        while (x[startI] == ignore || y[startI] == ignore) {
            if (++startI < x.length) continue;
            throw new StatsException("All points are ignored");
        }
        double mean_x = x[startI];
        double mean_y = y[startI];
        for (int i = startI + 1; i < n; ++i) {
            if (x[i] == ignore || y[i] == ignore) continue;
            double sweep = ((double)i - 1.0) / (double)i;
            double delta_x = x[i] - mean_x;
            double delta_y = y[i] - mean_y;
            if (Double.isNaN(delta_x) || Double.isInfinite(delta_x)) {
                throw new StatsException("Error computing Pearson correlation: NaN or Infinity");
            }
            if (Double.isNaN(delta_y) || Double.isInfinite(delta_y)) {
                throw new StatsException("Error computing Pearson correlation: NaN or Infinity");
            }
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (double)i;
            mean_y += delta_y / (double)i;
        }
        if (sum_sq_x == 0.0 || sum_sq_y == 0.0) {
            throw new StatsException("Can't compute Pearson correlation: distribution has no variance");
        }
        double cov_x_y = sum_coproduct / (double)n;
        double pop_sd_x = Math.sqrt(sum_sq_x / (double)n);
        double correlation = cov_x_y / (pop_sd_x * (pop_sd_y = Math.sqrt(sum_sq_y / (double)n)));
        if (Double.isNaN(correlation) || Double.isInfinite(correlation)) {
            throw new StatsException("Error computing Pearson correlation: NaN or Infinity");
        }
        return correlation;
    }
}

