/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.stats.SimpleXYSeries;
import com.davidsoergel.stats.StatsException;
import com.davidsoergel.stats.StatsRuntimeException;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Histogram1D {
    private static final Logger logger = Logger.getLogger(Histogram1D.class);
    double validcounts;
    double totalcounts;
    private double[] counts;
    private double[] cumulativeCounts;
    protected int bins;
    protected double from;
    protected double to;
    private double totalsum = 0.0;

    public Histogram1D(double from, double to, int bins) {
        if (from > to) {
            throw new StatsRuntimeException("Can't build a histogram with negative width from " + from + " to " + to);
        }
        this.from = from;
        this.to = to;
        this.bins = bins;
        this.counts = new double[bins];
    }

    public double[] getCounts() {
        return (double[])this.counts.clone();
    }

    public void addXValues(SimpleXYSeries s) {
        for (double d : s.getXArray()) {
            this.add(d);
        }
    }

    public void add(double x) {
        try {
            int n = this.findBinNumber(x);
            this.counts[n] = this.counts[n] + 1.0;
            this.validcounts += 1.0;
        }
        catch (StatsException statsException) {
            // empty catch block
        }
        this.totalsum += x;
        this.totalcounts += 1.0;
        this.invalidateDerived();
    }

    public void add(double x, double repetitions) {
        try {
            int n = this.findBinNumber(x);
            this.counts[n] = this.counts[n] + repetitions;
            this.validcounts += repetitions;
        }
        catch (StatsException e) {
            // empty catch block
        }
        this.totalsum += x * repetitions;
        this.totalcounts += repetitions;
        this.invalidateDerived();
    }

    protected void incrementBin(int bin) {
        int n = bin;
        this.counts[n] = this.counts[n] + 1.0;
        this.invalidateDerived();
    }

    public abstract int findBinNumber(double var1) throws StatsException;

    public void addXValues(Set<SimpleXYSeries> ss) {
        for (SimpleXYSeries s : ss) {
            this.addXValues(s);
        }
    }

    public void addYValues(SimpleXYSeries s) {
        for (double i : s.getYArray()) {
            this.add(i);
        }
    }

    public void addYValues(Set<SimpleXYSeries> ss) {
        for (SimpleXYSeries s : ss) {
            this.addYValues(s);
        }
    }

    public double approximateStdDev() {
        double mean = this.mean();
        double var = 0.0;
        for (int i = 0; i < this.counts.length; ++i) {
            double d = 0.0;
            try {
                d = this.centerOfBin(i) - mean;
            }
            catch (StatsException e) {
                logger.error("Error", e);
                throw new Error("Impossible");
            }
            var += this.counts[i] * d * d;
        }
        return Math.sqrt(var /= this.validcounts);
    }

    public double mean() {
        return this.totalsum / this.totalcounts;
    }

    public double centerOfBin(int i) throws StatsException {
        return (this.topOfBin(i) + this.bottomOfBin(i)) / 2.0;
    }

    public double halfWidthOfBin(int i) throws StatsException {
        return (this.topOfBin(i) - this.bottomOfBin(i)) / 2.0;
    }

    public abstract double topOfBin(int var1) throws StatsException;

    public abstract double bottomOfBin(int var1) throws StatsException;

    public double[] getBinCenters() throws StatsException {
        double[] result = new double[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            result[i] = this.centerOfBin(i);
        }
        return result;
    }

    public double[] getFractions() {
        if (this.totalcounts == 0.0) {
            return null;
        }
        double[] fractions = (double[])this.counts.clone();
        DSArrayUtils.multiplyBy(fractions, 1.0 / this.totalcounts);
        return fractions;
    }

    public double[] getCumulativeFractions() {
        double[] result = this.getFractions();
        for (int i = 1; i < result.length; ++i) {
            int n = i;
            result[n] = result[n] + result[i - 1];
        }
        return result;
    }

    private void invalidateDerived() {
        this.cumulativeCounts = null;
    }

    public double[] getCumulativeCounts() {
        if (this.cumulativeCounts == null) {
            this.cumulativeCounts = (double[])this.counts.clone();
            for (int i = 1; i < this.cumulativeCounts.length; ++i) {
                int n = i;
                this.cumulativeCounts[n] = this.cumulativeCounts[n] + this.cumulativeCounts[i - 1];
            }
        }
        return this.cumulativeCounts;
    }

    public void setTotalcounts(double totalcounts) {
        this.totalcounts = totalcounts;
    }

    public double getCount(int bin) {
        return this.counts[bin];
    }
}

