/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.stats.StatsException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections15.map.MultiKeyMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeatmapSeries {
    private static final Logger logger = Logger.getLogger(HeatmapSeries.class);
    private MultiKeyMap<Double, HeatmapPoint> points = new MultiKeyMap();
    protected double xMin = Double.POSITIVE_INFINITY;
    protected double xMax = Double.NEGATIVE_INFINITY;
    private double yMin = Double.POSITIVE_INFINITY;
    private double yMax = Double.NEGATIVE_INFINITY;
    private double zMin = Double.POSITIVE_INFINITY;
    private double zMax = Double.NEGATIVE_INFINITY;

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getZMin() {
        return this.zMin;
    }

    public void addPoint(double x, double y, double z, double startx, double endx, double starty, double endy) throws StatsException {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            logger.warn("Invalid x value in HeatmapSeries: " + x);
            return;
        }
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            logger.warn("Invalid y value in HeatmapSeries: " + y);
            return;
        }
        if (Double.isNaN(z) || Double.isInfinite(z)) {
            logger.warn("Invalid z value in HeatmapSeries: " + z);
            return;
        }
        this.points.put(x, y, new HeatmapPoint(x, y, z, startx, endx, starty, endy));
        this.updateBounds(x, y, z);
    }

    public void incrementPoint(double x, double y, double zIncrement, double startx, double endx, double starty, double endy) throws StatsException {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            logger.warn("Invalid x value in HeatmapSeries: " + x);
            return;
        }
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            logger.warn("Invalid y value in HeatmapSeries: " + y);
            return;
        }
        if (Double.isNaN(zIncrement) || Double.isInfinite(zIncrement)) {
            logger.warn("Invalid zIncrement value in SimpleXYZSeries: " + zIncrement);
            return;
        }
        HeatmapPoint currentPoint = this.points.get((K[])new Double[]{x, y});
        if (currentPoint != null) {
            currentPoint.z += zIncrement;
            this.updateBounds(x, y, currentPoint.z);
        } else {
            this.points.put(x, y, new HeatmapPoint(x, y, zIncrement, startx, endx, starty, endy));
            this.updateBounds(x, y, zIncrement);
        }
    }

    private void updateBounds(double x, double y, double z) {
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
        if (z > this.zMax) {
            this.zMax = z;
        }
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
        if (z < this.zMin) {
            this.zMin = z;
        }
    }

    public double getX(int i) {
        return this.points.get((Object)Integer.valueOf((int)i)).x;
    }

    public double[] getXArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (HeatmapPoint p : this.points.values()) {
            result[i] = p.x;
            ++i;
        }
        return result;
    }

    public double getY(int i) {
        return this.points.get((Object)Integer.valueOf((int)i)).y;
    }

    public double[] getYArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (HeatmapPoint p : this.points.values()) {
            result[i] = p.y;
            ++i;
        }
        return result;
    }

    public double getZ(int i) {
        return this.points.get((Object)Integer.valueOf((int)i)).z;
    }

    public double[] getZArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (HeatmapPoint p : this.points.values()) {
            result[i] = p.z;
            ++i;
        }
        return result;
    }

    public double[] getStartXArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (HeatmapPoint p : this.points.values()) {
            result[i] = p.startx;
            ++i;
        }
        return result;
    }

    public double[] getEndXArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (HeatmapPoint p : this.points.values()) {
            result[i] = p.endx;
            ++i;
        }
        return result;
    }

    public double[] getStartYArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (HeatmapPoint p : this.points.values()) {
            result[i] = p.starty;
            ++i;
        }
        return result;
    }

    public double[] getEndYArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (HeatmapPoint p : this.points.values()) {
            result[i] = p.endy;
            ++i;
        }
        return result;
    }

    public int size() {
        return this.points.size();
    }

    public List<HeatmapPoint> getPoints() {
        return new ArrayList<HeatmapPoint>(this.points.values());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeatmapPoint
    implements Comparable<HeatmapPoint> {
        public double x;
        public double y;
        public double z;
        public double startx;
        public double endx;
        public double starty;
        public double endy;

        public HeatmapPoint(double x, double y, double z, double startx, double endx, double starty, double endy) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.startx = startx;
            this.endx = endx;
            this.starty = starty;
            this.endy = endy;
        }

        @Override
        public int compareTo(HeatmapPoint o) {
            int c = Double.compare(this.x, o.x);
            if (c == 0) {
                c = Double.compare(this.y, o.y);
            }
            if (c == 0) {
                c = Double.compare(this.z, o.z);
            }
            return c;
        }
    }
}

