/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.stats.EqualWeightHistogram1D;
import com.davidsoergel.stats.SimpleXYSeries;
import com.davidsoergel.stats.StatsException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualWeightHistogram2D {
    private static final Logger logger = Logger.getLogger(EqualWeightHistogram2D.class);
    private EqualWeightHistogram1D theBaseHistogram;
    private List<EqualWeightHistogram1D> thePerBinHistograms = new ArrayList<EqualWeightHistogram1D>();

    public EqualWeightHistogram2D(SimpleXYSeries xy, int xBins, int yBins) throws StatsException {
        this(xy, xBins, yBins, false);
    }

    public EqualWeightHistogram2D(SimpleXYSeries xy, int xBins, int yBins, boolean cumulative) throws StatsException {
        this.theBaseHistogram = new EqualWeightHistogram1D(xBins, xy.getXArray());
        for (int i = 0; i < xBins; ++i) {
            double xmin = cumulative ? 0.0 : this.theBaseHistogram.bottomOfBin(i);
            double xmax = this.theBaseHistogram.topOfBin(i);
            this.thePerBinHistograms.add(new EqualWeightHistogram1D(yBins, xy.getYArray(xmin, xmax)));
        }
    }

    public EqualWeightHistogram1D getTheBaseHistogram() {
        return this.theBaseHistogram;
    }

    public List<EqualWeightHistogram1D> getThePerBinHistograms() {
        return this.thePerBinHistograms;
    }

    public SimpleXYSeries getYBinBoundarySeries(int yBinNumber) throws StatsException {
        SimpleXYSeries result = new SimpleXYSeries();
        double i = 1.0;
        double xBins = this.theBaseHistogram.getBins();
        for (EqualWeightHistogram1D yBin : this.thePerBinHistograms) {
            result.addPoint(i * (1.0 / xBins), yBin.topOfBin(yBinNumber));
            i += 1.0;
        }
        return result;
    }
}

