/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.stats.StatsException;
import com.davidsoergel.stats.VariableWidthHistogram1D;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class EqualWeightHistogram1D
extends VariableWidthHistogram1D {
    private static final Logger logger = Logger.getLogger(EqualWeightHistogram1D.class);
    private final boolean failOnTooLittleData;

    public EqualWeightHistogram1D(int bins, double[] data) throws StatsException {
        this(DSArrayUtils.min(data), DSArrayUtils.max(data), bins, data, false);
    }

    public EqualWeightHistogram1D(int bins, double[] data, boolean failOnTooLittleData) throws StatsException {
        this(DSArrayUtils.min(data), DSArrayUtils.max(data), bins, data, failOnTooLittleData);
    }

    public EqualWeightHistogram1D(double from, double to, int bins, boolean failOnTooLittleData) {
        super(from, to, bins);
        this.failOnTooLittleData = false;
    }

    public EqualWeightHistogram1D(double from, double to, int bins, double[] data, boolean failOnTooLittleData) throws StatsException {
        super(from, to, bins);
        this.failOnTooLittleData = failOnTooLittleData;
        this.addAll(data);
    }

    private void addAll(double[] data) throws StatsException {
        double pointsPerBin = (double)data.length / (double)this.bins;
        if (pointsPerBin < 1.0 && this.failOnTooLittleData) {
            throw new StatsException("Can't compute a good histogram for " + this.bins + " bins with only " + data.length + " data points");
        }
        Arrays.sort(data);
        int prevBin = 0;
        for (int dataIndex = 0; dataIndex < data.length; ++dataIndex) {
            int bin = (int)((double)dataIndex / pointsPerBin);
            if (bin >= this.bins) {
                bin = this.bins - 1;
            }
            if (bin != prevBin) {
                this.lowerBoundaries[bin] = data[dataIndex];
            }
            this.incrementBin(bin);
            prevBin = bin;
        }
    }

    public int getBins() {
        return this.bins;
    }
}

