/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.math.MersenneTwisterFast;
import com.davidsoergel.stats.BinnedXYSeries;
import com.davidsoergel.stats.DistributionException;
import com.davidsoergel.stats.EqualWeightHistogram1D;
import com.davidsoergel.stats.LinearRegression;
import com.davidsoergel.stats.PearsonCorrelation;
import com.davidsoergel.stats.SimpleXYSeries;
import com.davidsoergel.stats.StatsException;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionXYSeries {
    private static final Logger logger = Logger.getLogger(DistributionXYSeries.class);
    SortedSet<Double> keys = new TreeSet<Double>();
    Map<Double, Multiset<Double>> yValsPerX = new HashMap<Double, Multiset<Double>>();
    protected double xMin = Double.POSITIVE_INFINITY;
    protected double xMax = Double.NEGATIVE_INFINITY;
    private double yMin = Double.POSITIVE_INFINITY;
    private double yMax = Double.NEGATIVE_INFINITY;
    LinearRegression regression = null;
    double correlation;

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public void addPoint(double x, double y) {
        this.keys.add(x);
        this.getYMultiset(x).add(y);
        this.updateXBounds(x);
        this.updateYBounds(y);
    }

    private void updateXBounds(double x) {
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (x > this.xMax) {
            this.xMax = x;
        }
    }

    private void updateYBounds(double y) {
        if (y < this.yMin) {
            this.yMin = y;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
    }

    public void addPoints(double x, Collection<Double> ys) {
        this.keys.add(x);
        this.getYMultiset(x).addAll(ys);
        this.updateXBounds(x);
        for (Double y : ys) {
            this.updateYBounds(y);
        }
    }

    private Multiset<Double> getYMultiset(double x) {
        Multiset<Double> result = this.yValsPerX.get(x);
        if (result == null) {
            result = HashMultiset.create();
            this.yValsPerX.put(x, result);
        }
        return result;
    }

    public Set<Double> uniqueXValues() {
        return this.yValsPerX.keySet();
    }

    public double meanYAtX(double x) {
        return DSArrayUtils.mean(this.getYMultiset(x));
    }

    public double stddevYAtX(double x, double mean) {
        return DSArrayUtils.stddev(this.getYMultiset(x), mean);
    }

    public double meanYAtXCumulative(double xTop) {
        return DSArrayUtils.mean(this.getYList(0.0, xTop));
    }

    public double stddevYAtXCumulative(double xTop, double mean) {
        return DSArrayUtils.stddev(this.getYList(0.0, xTop), mean);
    }

    public BinnedXYSeries makeBinnedXYSeries(double halfBinWidth, double binStep) {
        try {
            BinnedXYSeries result = new BinnedXYSeries(this);
            if (binStep == 0.0) {
                Iterator i$ = this.keys.iterator();
                while (i$.hasNext()) {
                    double x = (Double)i$.next();
                    result.addBin(x, halfBinWidth);
                }
            } else {
                for (double center = this.xMin; center < this.xMax; center += binStep) {
                    result.addBin(center, halfBinWidth);
                }
            }
            return result;
        }
        catch (DistributionException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
    }

    public BinnedXYSeries binXTiles(int numBins) {
        double binWidth = (this.xMax - this.xMin) / (double)numBins;
        return this.makeBinnedXYSeries(binWidth / 2.0, binWidth);
    }

    public BinnedXYSeries binXQuantiles(int numQuantiles) {
        try {
            BinnedXYSeries result = new BinnedXYSeries(this);
            HashMultiset<Double> allXValues = HashMultiset.create();
            for (Map.Entry<Double, Multiset<Double>> entry : this.yValsPerX.entrySet()) {
                allXValues.add(entry.getKey(), entry.getValue().size());
            }
            EqualWeightHistogram1D theBaseHistogram = new EqualWeightHistogram1D(numQuantiles, DSArrayUtils.toPrimitiveArray(allXValues));
            int numBins = theBaseHistogram.getBins();
            for (int i = 0; i < numBins; ++i) {
                double center = theBaseHistogram.centerOfBin(i);
                double halfBinWidth = theBaseHistogram.halfWidthOfBin(i);
                result.addBin(center, halfBinWidth);
            }
            return result;
        }
        catch (DistributionException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
        catch (StatsException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
    }

    public List<Double> getYList(double bottom, double top) {
        ArrayList<Double> result = new ArrayList<Double>();
        try {
            double last = this.keys.last();
            double topTrim = Math.min(top, last);
            for (Double x : this.keys.tailSet(bottom).headSet(topTrim)) {
                int i = result.size();
                Multiset<Double> multiset = this.yValsPerX.get(x);
                result.addAll(multiset);
                assert (result.size() == i + multiset.size());
            }
            if (top > last) {
                result.addAll((Collection<Double>)this.yValsPerX.get(last));
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return result;
    }

    public int size() {
        int result = 0;
        for (Multiset<Double> doubles : this.yValsPerX.values()) {
            result += doubles.size();
        }
        return result;
    }

    public SimpleXYSeries asSimpleXYSeries() throws StatsException {
        SimpleXYSeries result = new SimpleXYSeries();
        for (Double x : this.keys) {
            for (Double y : this.getYMultiset(x)) {
                result.addPoint(x, y);
            }
        }
        return result;
    }

    public double pearsonCorrelation() throws StatsException {
        if (this.regression == null) {
            this.computeRegression();
        }
        return this.correlation;
    }

    public double R2() throws StatsException {
        if (this.regression == null) {
            this.computeRegression();
        }
        logger.debug("Correlations: " + this.regression.R2 + ", " + this.correlation);
        return this.regression.R2;
    }

    public double regressionM() throws StatsException {
        if (this.regression == null) {
            this.computeRegression();
        }
        return this.regression.slope;
    }

    public double regressionB() throws StatsException {
        if (this.regression == null) {
            this.computeRegression();
        }
        return this.regression.intercept;
    }

    private void computeRegression() throws StatsException {
        double[] xs = new double[this.size()];
        double[] ys = new double[this.size()];
        int i = 0;
        for (Double x : this.keys) {
            for (Double y : this.getYMultiset(x)) {
                xs[i] = x;
                ys[i] = y;
                ++i;
            }
        }
        this.regression = new LinearRegression(xs, ys);
        this.correlation = PearsonCorrelation.computeCorrelationCoefficient(xs, ys);
    }

    public void addAllVsAllPoints(List<Double> xValues, List<Double> yValues, boolean xlog, boolean ylog, double xnoise, double ynoise) {
        for (double dx : xValues) {
            if (xlog) {
                dx = Math.log10(dx);
            }
            for (double dy : yValues) {
                if (ylog) {
                    dy = Math.log10(dy);
                }
                double dxn = dx;
                if (xnoise != 0.0) {
                    dxn += xnoise * (MersenneTwisterFast.gaussian() - 0.5);
                }
                if (ynoise != 0.0) {
                    dy += ynoise * (MersenneTwisterFast.gaussian() - 0.5);
                }
                this.addPoint(dxn, dy);
            }
        }
    }

    public void addParallelArrayPoints(List<Double> xValues, List<Double> yValues, boolean xlog, boolean ylog, double xnoise, double ynoise) {
        Iterator<Double> yIterator = yValues.iterator();
        for (double dx : xValues) {
            if (xlog) {
                dx = Math.log10(dx);
            }
            if (xnoise != 0.0) {
                dx += xnoise * (MersenneTwisterFast.gaussian() - 0.5);
            }
            double dy = yIterator.next();
            if (ylog) {
                dy = Math.log10(dy);
            }
            if (ynoise != 0.0) {
                dy += ynoise * (MersenneTwisterFast.gaussian() - 0.5);
            }
            this.addPoint(dx, dy);
        }
    }

    public void addParallelArrayPoints(List<Double> xValues, List<Double> yValues, boolean xlog, boolean ylog, double xnoise, double ynoise, List<Double> maskValues, double maskMin, double maskMax, List<Double> mask2Values, double mask2Min, double mask2Max) {
        Iterator<Double> yIterator = yValues.iterator();
        Iterator<Double> maskIterator = maskValues.iterator();
        Iterator<Double> mask2Iterator = mask2Values.iterator();
        for (double dx : xValues) {
            double dMask = maskIterator.next();
            double dMask2 = mask2Iterator.next();
            double dy = yIterator.next();
            if (dMask >= maskMin && dMask <= maskMax && dMask2 >= mask2Min && dMask2 <= mask2Max) {
                if (xlog) {
                    dx = Math.log10(dx);
                }
                if (xnoise != 0.0) {
                    dx += xnoise * (MersenneTwisterFast.gaussian() - 0.5);
                }
                if (ylog) {
                    dy = Math.log10(dy);
                }
                if (ynoise != 0.0) {
                    dy += ynoise * (MersenneTwisterFast.gaussian() - 0.5);
                }
                this.addPoint(dx, dy);
                continue;
            }
            this.addPoint(dx, Double.NaN);
        }
    }

    public void addParallelArrayPoints(List<Double> xValues, List<Double> yValues, boolean xlog, boolean ylog, double xnoise, double ynoise, List<Double> maskValues, double maskMin, double maskMax) {
        Iterator<Double> yIterator = yValues.iterator();
        Iterator<Double> maskIterator = maskValues.iterator();
        for (double dx : xValues) {
            double dMask = maskIterator.next();
            double dy = yIterator.next();
            if (dMask >= maskMin && dMask <= maskMax) {
                if (xlog) {
                    dx = Math.log10(dx);
                }
                if (xnoise != 0.0) {
                    dx += xnoise * (MersenneTwisterFast.gaussian() - 0.5);
                }
                if (ylog) {
                    dy = Math.log10(dy);
                }
                if (ynoise != 0.0) {
                    dy += ynoise * (MersenneTwisterFast.gaussian() - 0.5);
                }
                this.addPoint(dx, dy);
                continue;
            }
            this.addPoint(dx, Double.NaN);
        }
    }
}

