/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.stats.DistributionException;
import com.davidsoergel.stats.DistributionXYSeries;
import com.davidsoergel.stats.EqualWeightHistogram1D;
import com.davidsoergel.stats.SimpleXYSeries;
import com.davidsoergel.stats.StatsException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinnedXYSeries {
    private List<Double> xCenters = new ArrayList<Double>();
    private List<Double> xHalfWidths = new ArrayList<Double>();
    private final DistributionXYSeries basedOnSeries;

    public BinnedXYSeries(DistributionXYSeries basedOnSeries) {
        this.basedOnSeries = basedOnSeries;
    }

    public double getHalfXWidthForBin(int i) {
        return this.xHalfWidths.get(i);
    }

    private EqualWeightHistogram1D getYQuantilesForBin(int i, int yQuantiles) throws StatsException {
        double[] yPrimitiveArray = DSArrayUtils.toPrimitiveArray(this.getYListForBin(i));
        if (yPrimitiveArray.length == 0) {
            return null;
        }
        return new EqualWeightHistogram1D(yQuantiles, yPrimitiveArray);
    }

    public List<Double> getYListForBin(int i) {
        double x = this.xCenters.get(i);
        double halfBinWidth = this.xHalfWidths.get(i);
        if (halfBinWidth == 0.0) {
            halfBinWidth += Math.ulp(halfBinWidth);
        }
        double bottom = x - halfBinWidth;
        double top = x + halfBinWidth;
        return this.basedOnSeries.getYList(bottom, top);
    }

    private EqualWeightHistogram1D getYQuantilesForBinCumulative(int i, int yQuantiles) throws StatsException {
        double[] yPrimitiveArray = DSArrayUtils.toPrimitiveArray(this.getYListForBinRangeToTop(0, i));
        if (yPrimitiveArray.length == 0) {
            return null;
        }
        return new EqualWeightHistogram1D(yQuantiles, yPrimitiveArray);
    }

    public List<Double> getYListForBinRangeToTop(int lowBin, int highBin) {
        if (highBin == -1) {
            return new ArrayList<Double>();
        }
        double highX = this.xCenters.get(highBin);
        double highHalfBinWidth = this.xHalfWidths.get(highBin);
        double xTop = highX + highHalfBinWidth;
        double lowX = this.xCenters.get(lowBin);
        double lowHalfBinWidth = this.xHalfWidths.get(lowBin);
        double xBottom = lowX - lowHalfBinWidth;
        return this.basedOnSeries.getYList(xBottom, xTop);
    }

    public List<Double> getYListForBinRangeToCenter(int lowBin, int highBin) {
        double lowX = this.xCenters.get(lowBin);
        double lowHalfBinWidth = this.xHalfWidths.get(lowBin);
        double xBottom = lowX - lowHalfBinWidth;
        double center = this.xCenters.get(highBin);
        center += Math.ulp(center);
        return this.basedOnSeries.getYList(xBottom, center);
    }

    public List<Double> getYListForBinBottomHalf(int bin) {
        double x = this.xCenters.get(bin);
        double halfBinWidth = this.xHalfWidths.get(bin);
        double xBottom = x - halfBinWidth;
        x += Math.ulp(x);
        return this.basedOnSeries.getYList(xBottom, x);
    }

    public List<Double> getYListForBinTopHalf(int bin) {
        double x = this.xCenters.get(bin);
        double halfBinWidth = this.xHalfWidths.get(bin);
        double xTop = x + halfBinWidth;
        x += Math.ulp(x);
        return this.basedOnSeries.getYList(x, xTop);
    }

    public void addBin(double xCenter, double halfBinWidth) throws DistributionException {
        this.xCenters.add(xCenter);
        this.xHalfWidths.add(halfBinWidth);
    }

    public SimpleXYSeries getQuantileSeries(int yQuantiles, int yQuantile, boolean cumulative) throws StatsException {
        if (cumulative) {
            return this.getCumulativeQuantileSeries(yQuantiles, yQuantile);
        }
        return this.getQuantileSeries(yQuantiles, yQuantile);
    }

    public SimpleXYSeries getCumulativeQuantileSeries(int yQuantiles, int yQuantile) throws StatsException {
        SimpleXYSeries result = new SimpleXYSeries();
        for (int i = 0; i < this.xCenters.size(); ++i) {
            double x = this.xCenters.get(i);
            EqualWeightHistogram1D hist = this.getYQuantilesForBinCumulative(i, yQuantiles);
            if (hist == null) {
                result.addPoint(x, 0.0);
                continue;
            }
            double y = hist.topOfBin(yQuantile);
            result.addPoint(x, y);
        }
        return result;
    }

    public SimpleXYSeries getQuantileSeries(int yQuantiles, int yQuantile) throws StatsException {
        SimpleXYSeries result = new SimpleXYSeries();
        for (int i = 0; i < this.xCenters.size(); ++i) {
            double x = this.xCenters.get(i);
            EqualWeightHistogram1D hist = this.getYQuantilesForBin(i, yQuantiles);
            if (hist == null) {
                result.addPoint(x, 0.0);
                continue;
            }
            double y = hist.topOfBin(yQuantile);
            result.addPoint(x, y);
        }
        return result;
    }

    public double countYForBin(int i) {
        return this.getYListForBin(i).size();
    }

    private double countYForBinCumulative(int i) {
        return this.getYListForBinRangeToTop(0, i).size();
    }

    public int numBins() {
        return this.xCenters.size();
    }

    public List<Double> getBinCenters() {
        return this.xCenters;
    }

    public Double getBinCenter(int i) {
        return this.xCenters.get(i);
    }

    public double meanYForBin(int i) {
        return DSArrayUtils.mean(this.getYListForBin(i));
    }

    public double stddevYForBin(int i, double mean) {
        return DSArrayUtils.stddev(this.getYListForBin(i), mean);
    }

    public int size() {
        return this.basedOnSeries.size();
    }
}

