/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.runutils.QueueableTask;
import com.davidsoergel.runutils.TaskListener;
import com.davidsoergel.runutils.TaskQueueProcessorThread;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskQueue<T extends QueueableTask> {
    private static final Logger logger = Logger.getLogger(TaskQueue.class);
    Throwable error = null;
    private ConcurrentLinkedQueue<T> theQueue = new ConcurrentLinkedQueue();
    private int activeThreads = 0;
    private boolean wantsToFinish = false;
    private int threadNum = 1;
    private Set<TaskQueueProcessorThread<T>> instanceThreads = new HashSet<TaskQueueProcessorThread<T>>();
    private TaskListener notify;
    private String name;
    private Set<T> allTasks = new HashSet<T>();

    public TaskQueue(String n) {
        this.name = n;
        this.init();
    }

    private void init() {
        int i;
        this.wantsToFinish = false;
        logger.info("Initializing " + this.threadNum + " " + this.name + " Threads...");
        for (i = 0; i < this.threadNum; ++i) {
            TaskQueueProcessorThread instance = new TaskQueueProcessorThread(this, this.name + " Thread " + i);
            this.instanceThreads.add(instance);
            instance.start();
        }
        this.activeThreads = i;
    }

    public TaskQueue(String n, int threads) {
        this(n, null, threads);
    }

    public TaskQueue(String n, TaskListener noti) {
        this.name = n;
        this.notify = noti;
        this.init();
    }

    public TaskQueue(String n, TaskListener noti, int threads) {
        this.name = n;
        this.threadNum = threads;
        this.notify = noti;
        this.init();
    }

    public int getActiveThreads() {
        return this.activeThreads;
    }

    public void addTask(T t) {
        this.theQueue.add(t);
        this.allTasks.add(t);
    }

    public void finish() {
        this.wantsToFinish = true;
    }

    public Set<T> getTasks() {
        return this.allTasks;
    }

    public void notifyThreadFailed(Throwable e) {
        --this.activeThreads;
        this.error = e;
        if (this.activeThreads <= 0 && this.notify != null) {
            this.notify.notifyExit(this.name);
        }
    }

    public void notifyThreadFinished() {
        --this.activeThreads;
        if (this.activeThreads <= 0 && this.notify != null) {
            this.notify.notifyExit(this.name);
        }
    }

    public T poll() {
        return (T)((QueueableTask)this.theQueue.poll());
    }

    public int size() {
        return this.theQueue.size();
    }

    public void waitForExit() {
        while (true) {
            if (this.error != null) {
                throw new Error(this.error);
            }
            if (this.wantsToFinish && this.activeThreads <= 0) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean wantsToFinish() {
        return this.wantsToFinish;
    }
}

