/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.dsutils.DSClassUtils;
import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.GenericFactoryAware;
import com.davidsoergel.dsutils.GenericFactoryException;
import com.davidsoergel.dsutils.PluginException;
import com.davidsoergel.runutils.InjectableValueMapper;
import com.davidsoergel.runutils.ResultsCollectingProgramRun;
import com.davidsoergel.trees.htpn.ExtendedHierarchicalTypedPropertyNode;
import com.davidsoergel.trees.htpn.HierarchicalPropertyNodeException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyConsumerFactory<T>
implements GenericFactory<T>,
Comparable<T> {
    private static final Logger logger = Logger.getLogger(PropertyConsumerFactory.class);
    private final Class theClass;
    private final Map<String, Object> injectableValues;

    public PropertyConsumerFactory(ExtendedHierarchicalTypedPropertyNode<String, Serializable, ?> dataSource, ClassLoader classLoader) throws ClassNotFoundException, HierarchicalPropertyNodeException {
        Object value = dataSource.getValue();
        if (!(value instanceof Class)) {
            throw new HierarchicalPropertyNodeException("Node does not represent a plugin, so we can't make a factory from it: " + dataSource);
        }
        this.theClass = (Class)value;
        this.injectableValues = InjectableValueMapper.mapChildren(dataSource);
    }

    public String toString() {
        return this.theClass == null ? "" : this.theClass.getSimpleName();
    }

    @Override
    public int compareTo(T o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public Class getCreatesClass() {
        return this.theClass;
    }

    @Override
    public T create(Object ... constructorArguments) throws GenericFactoryException {
        try {
            Class[] argtypes = DSClassUtils.getClasses(constructorArguments);
            Constructor theConstructor = DSClassUtils.findConstructor(this.theClass, argtypes);
            Object result = theConstructor.newInstance(constructorArguments);
            this.injectInto(result);
            if (result instanceof GenericFactoryAware) {
                ((GenericFactoryAware)result).setFactory(this);
            }
            try {
                Method m = this.theClass.getDeclaredMethod("init", new Class[0]);
                m.invoke(result, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return result;
        }
        catch (NoSuchMethodException e) {
            throw new GenericFactoryException(e);
        }
        catch (InstantiationException e) {
            logger.error("Error", e);
            throw new GenericFactoryException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error", e);
            throw new GenericFactoryException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("Error", e);
            if (e.getCause() instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e.getCause();
            }
            throw new GenericFactoryException(e);
        }
    }

    public ResultsCollectingProgramRun getResultsCollectingProgramRun() throws PluginException, HierarchicalPropertyNodeException {
        if (!ResultsCollectingProgramRun.class.isAssignableFrom(this.theClass)) {
            throw new HierarchicalPropertyNodeException("Can't get run for a class that doesn't extend ResultsCollectingProgramRun");
        }
        try {
            Object result = this.theClass.newInstance();
            this.injectInto(result);
            return (ResultsCollectingProgramRun)result;
        }
        catch (InstantiationException e) {
            logger.error("Error", e);
            throw new HierarchicalPropertyNodeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error", e);
            throw new HierarchicalPropertyNodeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void injectInto(T o) {
        assert (o.getClass().equals(this.theClass));
        try {
            for (Map.Entry<String, Object> entry : this.injectableValues.entrySet()) {
                Object injectableValue = null;
                Field f = null;
                try {
                    f = this.theClass.getField(entry.getKey());
                    injectableValue = entry.getValue();
                    if (injectableValue instanceof GenericFactory && !PropertyConsumerFactory.isGenericFactory(f)) {
                        injectableValue = ((GenericFactory)injectableValue).create(new Object[0]);
                    }
                    f.set(o, injectableValue);
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalArgumentException e) {
                    throw new Error("Can't inject " + injectableValue + (injectableValue == null ? "" : " of type " + injectableValue.getClass()) + " into field \"" + f + "\"", e);
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error", e);
        }
    }

    private static boolean isGenericFactory(Field f) {
        Type genericType = f.getGenericType();
        if (genericType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)genericType).getRawType();
            return rawType.equals(GenericFactory.class);
        }
        return genericType.equals(GenericFactory.class);
    }
}

