/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.SubclassFinder;
import com.davidsoergel.dsutils.TypeUtils;
import com.davidsoergel.dsutils.collections.OrderedPair;
import com.davidsoergel.dsutils.increment.BasicIncrementor;
import com.davidsoergel.dsutils.stringmapper.TypedValueStringMapper;
import com.davidsoergel.runutils.Property;
import com.davidsoergel.runutils.PropertyConsumer;
import com.davidsoergel.runutils.PropertyConsumerHTPN;
import com.davidsoergel.trees.htpn.HierarchicalPropertyNodeException;
import com.davidsoergel.trees.htpn.HierarchicalTypedPropertyNode;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyConsumerClassParser {
    private static final Logger logger = Logger.getLogger(PropertyConsumerClassParser.class);
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static void setClassLoader(ClassLoader classLoader) {
        PropertyConsumerClassParser.classLoader = classLoader;
    }

    public static List<Class> getRootConsumerClasses(String rootPackageName) throws IOException {
        ArrayList<Class> result = new ArrayList<Class>();
        for (Class c : SubclassFinder.findRecursive(rootPackageName, Object.class, PropertyConsumer.class, new BasicIncrementor(null, null))) {
            PropertyConsumer pc = c.getAnnotation(PropertyConsumer.class);
            if (!pc.isProgram()) continue;
            result.add(c);
        }
        return result;
    }

    public static PropertyConsumerHTPN parseClass(String theClassName) throws HierarchicalPropertyNodeException, ClassNotFoundException {
        return PropertyConsumerClassParser.parseClass(Class.forName(theClassName, true, classLoader));
    }

    public static PropertyConsumerHTPN parseClass(Class theClass) throws HierarchicalPropertyNodeException {
        PropertyConsumerHTPN result = null;
        try {
            result = new PropertyConsumerHTPN();
            result.setType((Type)((Object)Class.class));
            result.setDefaultAndNullable(theClass, false);
        }
        catch (HierarchicalPropertyNodeException e) {
            logger.error("Error", e);
            throw new Error("Impossible failure to reload class " + theClass);
        }
        PropertyConsumerClassParser.parseClassIntoHTPN(result, theClass);
        for (PropertyConsumerHTPN node : result.getChildNodes()) {
            assert (node.getChildNodes().isEmpty());
        }
        return result;
    }

    private static void parseClassIntoHTPN(PropertyConsumerHTPN result, Class theClass) throws HierarchicalPropertyNodeException {
        HashSet<String> ignoreNames = new HashSet<String>();
        for (Field f : theClass.getFields()) {
            for (Annotation a : f.getDeclaredAnnotations()) {
                if (!(a instanceof Property)) continue;
                String propertyName = f.getName();
                if (((Property)a).ignore()) {
                    ignoreNames.add(propertyName);
                }
                if (Modifier.isStatic(f.getModifiers())) {
                    logger.error("Static fields cannot have a Property annotation: " + propertyName);
                    continue;
                }
                try {
                    PropertyConsumerClassParser.makeChildNodeForField(result, f, a);
                }
                catch (IncompleteAnnotationException e) {
                    logger.error("Broken Annotation: " + propertyName, e);
                    throw new HierarchicalPropertyNodeException(e);
                }
                catch (HierarchicalPropertyNodeException e) {
                    logger.error("Could not create node, ignoring: " + propertyName, e);
                }
            }
        }
        for (String ignoreName : ignoreNames) {
            result.removeChild(ignoreName);
        }
    }

    private static void makeChildNodeForField(PropertyConsumerHTPN result, Field f, Annotation a) throws HierarchicalPropertyNodeException {
        String propertyName = f.getName();
        String helpmessage = ((Property)a).helpmessage();
        boolean isInherited = ((Property)a).inherited();
        String defaultString = ((Property)a).defaultvalue();
        boolean isNullable = ((Property)a).isNullable();
        if (isInherited && defaultString != null && !defaultString.equals("")) {
            throw new HierarchicalPropertyNodeException("Inherited @Property can't have a default value: " + f.getDeclaringClass() + "." + f);
        }
        isNullable = isNullable || isInherited;
        Type type2 = f.getGenericType();
        if (TypeUtils.isAssignableFrom(GenericFactory.class, type2)) {
            Type factoryType = type2 instanceof Class ? type2 : ((ParameterizedType)type2).getActualTypeArguments()[0];
            if (helpmessage == null || helpmessage.equals("")) {
                helpmessage = "Parameters with which to create new " + factoryType;
            }
            if (defaultString == null || defaultString.equals("")) {
                if (factoryType instanceof Class) {
                    defaultString = ((Class)factoryType).getCanonicalName();
                } else {
                    throw new HierarchicalPropertyNodeException("GenericFactory of parameterized type requires a default value: " + f.getDeclaringClass() + "." + f);
                }
            }
        }
        Serializable defaultValue = PropertyConsumerClassParser.parseValueString(type2, defaultString);
        PropertyConsumerHTPN theChild = result.newChild(new OrderedPair<String, Object>(propertyName, null));
        theChild.setType(type2);
        theChild.setHelpmessage(helpmessage);
        theChild.setDefaultAndNullable(defaultValue, isNullable);
        if (isInherited) {
            theChild.setValue(HierarchicalTypedPropertyNode.PropertyConsumerFlags.INHERITED);
        }
        theChild.setObsolete(false);
    }

    protected static Serializable parseValueString(Type type2, String valueString) {
        if (valueString == null || valueString.equals("") || valueString.equals("null")) {
            return null;
        }
        Serializable result = (Serializable)TypedValueStringMapper.parse(type2, valueString);
        return result;
    }
}

