/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.dsutils.DSStringUtils;
import com.davidsoergel.dsutils.increment.BasicIncrementor;
import com.davidsoergel.dsutils.stringmapper.StringMapper;
import com.davidsoergel.dsutils.stringmapper.StringMapperException;
import com.davidsoergel.runutils.PluginMap;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginMapStringMapper
extends StringMapper<PluginMap> {
    private static final Logger logger = Logger.getLogger(PluginMapStringMapper.class);
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static void setClassLoader(ClassLoader classLoader) {
        PluginMapStringMapper.classLoader = classLoader;
    }

    @Override
    public Type[] basicTypes() {
        return new Type[]{PluginMap.class};
    }

    @Override
    public PluginMap parse(String s) throws StringMapperException {
        s = s.trim();
        int curlyOpen = s.indexOf("{");
        int curlyClose = s.indexOf("}");
        String className = s.substring(0, curlyOpen).trim();
        String packageNames = s.substring(curlyOpen + 1, curlyClose).trim();
        String defaultValue = s.substring(curlyClose + 1);
        PluginMap result = new PluginMap(packageNames.split(","), className, defaultValue, classLoader, new BasicIncrementor(null, null));
        return result;
    }

    @Override
    public String render(PluginMap value) {
        return value.getInterfaceName() + " {" + DSStringUtils.join(value.getPackageNames(), ",") + "} " + value.getDefaultString();
    }
}

