/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.runutils;

import com.davidsoergel.dsutils.DSStringUtils;
import com.davidsoergel.dsutils.EnumValue;
import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.GenericFactoryException;
import com.davidsoergel.dsutils.TypeUtils;
import com.davidsoergel.runutils.PropertyConsumerFactory;
import com.davidsoergel.runutils.PropertyConsumerRuntimeException;
import com.davidsoergel.trees.htpn.ExtendedHierarchicalTypedPropertyNode;
import com.davidsoergel.trees.htpn.HierarchicalPropertyNodeException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectableValueMapper {
    private static final Logger logger = Logger.getLogger(InjectableValueMapper.class);
    private static final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static Map<String, Object> mapChildren(ExtendedHierarchicalTypedPropertyNode<String, Serializable, ?> dataSource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ExtendedHierarchicalTypedPropertyNode child : dataSource.getChildNodes()) {
            Serializable newValue = (Serializable)child.getValue();
            if (newValue == null) continue;
            Object injectableValue = InjectableValueMapper.makeValueInjectable(newValue, child.getType(), child);
            result.put((String)child.getKey(), injectableValue);
        }
        return result;
    }

    private static Object makeValueInjectable(Serializable value, Type requiredType, ExtendedHierarchicalTypedPropertyNode<String, Serializable, ?> node) {
        Class rawRequiredClass = InjectableValueMapper.convertToRaw(requiredType);
        Object injectableValue = null;
        injectableValue = value instanceof Class ? InjectableValueMapper.convertPluginValue((Class)value, node, rawRequiredClass) : (value instanceof EnumValue ? InjectableValueMapper.convertEnumValue(value, rawRequiredClass) : (value instanceof Map && requiredType instanceof ParameterizedType ? InjectableValueMapper.makeMap(value, requiredType) : (rawRequiredClass.isArray() && value instanceof List ? InjectableValueMapper.makeArrayFromList(value, rawRequiredClass) : value)));
        return injectableValue;
    }

    private static Serializable convertEnumValue(Serializable value, Class rawRequiredClass) {
        assert (rawRequiredClass != null && rawRequiredClass.isEnum());
        if ((value = Enum.valueOf(rawRequiredClass, value.toString())) == null) {
            throw new PropertyConsumerRuntimeException("Enum value " + value + " not found");
        }
        return value;
    }

    private static Object convertPluginValue(Class concreteClass, ExtendedHierarchicalTypedPropertyNode<String, Serializable, ?> node, Class rawRequiredClass) {
        try {
            if (rawRequiredClass.equals(GenericFactory.class) || TypeUtils.isAssignableFrom(GenericFactory.class, concreteClass)) {
                return new PropertyConsumerFactory(node, classLoader);
            }
            return InjectableValueMapper.makeSingleConfiguredInstance(concreteClass, node);
        }
        catch (ClassNotFoundException e) {
            logger.error("Error at " + DSStringUtils.join((Object[])node.getKeyPath(), "."), e);
            throw new PropertyConsumerRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("Error at " + DSStringUtils.join((Object[])node.getKeyPath(), "."), e);
            throw new PropertyConsumerRuntimeException(e);
        }
        catch (HierarchicalPropertyNodeException e) {
            logger.error("Error at " + DSStringUtils.join((Object[])node.getKeyPath(), "."), e);
            throw new PropertyConsumerRuntimeException(e);
        }
        catch (GenericFactoryException e) {
            logger.error("Error at " + DSStringUtils.join((Object[])node.getKeyPath(), "."), e);
            throw new PropertyConsumerRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error at " + DSStringUtils.join((Object[])node.getKeyPath(), "."), e);
            throw new PropertyConsumerRuntimeException(e);
        }
    }

    private static Class convertToRaw(Type requiredType) {
        if (requiredType instanceof Class) {
            return (Class)requiredType;
        }
        if (requiredType instanceof ParameterizedType) {
            Type tc = ((ParameterizedType)requiredType).getRawType();
            if (tc instanceof Class) {
                return (Class)tc;
            }
            throw new PropertyConsumerRuntimeException("Type " + requiredType + " of unknown raw type " + tc);
        }
        throw new PropertyConsumerRuntimeException("Impossible: " + requiredType + " is neither a Class nor a ParameterizedType");
    }

    private static Object makeArrayFromList(Serializable value, Class rawRequiredClass) {
        Object[] injectableValue = ((List)((Object)value)).toArray((Object[])Array.newInstance(rawRequiredClass.getComponentType(), 0));
        return injectableValue;
    }

    private static Object makeMap(Serializable value, Type requiredType) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Object key : ((Map)((Object)value)).keySet()) {
            Object val = ((Map)((Object)value)).get(key);
            Type keyType = ((ParameterizedType)requiredType).getActualTypeArguments()[0];
            Type valType = ((ParameterizedType)requiredType).getActualTypeArguments()[1];
            result.put(InjectableValueMapper.makeValueInjectable((Serializable)((Object)key.toString()), keyType, null), InjectableValueMapper.makeValueInjectable((Serializable)((Object)val.toString()), valType, null));
        }
        HashMap<Object, Object> injectableValue = result;
        return injectableValue;
    }

    private static Object makeSingleConfiguredInstance(Class value, ExtendedHierarchicalTypedPropertyNode<String, Serializable, ?> node) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, HierarchicalPropertyNodeException, GenericFactoryException {
        try {
            Method singletonGetter = value.getMethod("getInjectedInstance", new Class[0]);
            Method singletonSetter = value.getMethod("setInjectedInstance", value);
            Object injectableValue = singletonGetter.invoke(null, new Object[0]);
            if (injectableValue == null) {
                PropertyConsumerFactory factory = new PropertyConsumerFactory(node, classLoader);
                injectableValue = factory.create(new Object[0]);
                singletonSetter.invoke(null, injectableValue);
            }
            return injectableValue;
        }
        catch (NoSuchMethodException e) {
            PropertyConsumerFactory factory = new PropertyConsumerFactory(node, classLoader);
            return factory.create(new Object[0]);
        }
    }
}

