/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.stringmapper;

import com.davidsoergel.dsutils.PluginValue;
import com.davidsoergel.dsutils.stringmapper.StringMapper;
import com.davidsoergel.dsutils.stringmapper.StringMapperException;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginMapper
extends StringMapper<PluginValue> {
    private static final Logger logger = Logger.getLogger(PluginMapper.class);
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static void setClassLoader(ClassLoader classLoader) {
        PluginMapper.classLoader = classLoader;
    }

    @Override
    public Type[] basicTypes() {
        return new Type[]{PluginValue.class};
    }

    @Override
    public PluginValue parse(String s) throws StringMapperException {
        if (s == null || s.trim().equals("")) {
            throw new StringMapperException("Empty plugin class name");
        }
        return new PluginValue(s);
    }

    @Override
    public String render(PluginValue value) {
        return value == null ? "null" : value.getValue();
    }

    @Override
    public String renderAbbreviated(PluginValue value) {
        if (value == null) {
            return "null";
        }
        String fullName = value.getValue();
        return fullName.substring(fullName.lastIndexOf("."));
    }
}

