/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.stringmapper;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.DSStringUtils;
import com.davidsoergel.dsutils.stringmapper.StringMapper;
import java.lang.reflect.Type;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntPrimitiveArrayMapper
extends StringMapper<int[]> {
    @Override
    public Type[] basicTypes() {
        return new Type[]{int[].class};
    }

    @Override
    public int[] parse(String s) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String d : s.split(",")) {
            result.add(Integer.parseInt(d));
        }
        return DSArrayUtils.toPrimitive(result.toArray(new Integer[0]));
    }

    @Override
    public String render(int[] value) {
        return DSStringUtils.join((Object[])DSArrayUtils.toObject(value), ",");
    }

    @Override
    public String renderHtml(int[] ss) {
        if (ss == null || ss.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer("<html>");
        sb.append("Array of ").append(ss.length).append(" Integers:<P>");
        if (ss.length <= 20) {
            int[] arr$ = ss;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer s = arr$[i$];
                sb.append(String.format("%d", s)).append("<BR>");
            }
        } else {
            for (int i = 0; i < ss.length; ++i) {
                sb.append(String.format("%d  ", ss[i]));
                if (i % 10 == 0) {
                    sb.append("<br>");
                }
                if (i != 400) continue;
                sb.append("...");
                break;
            }
        }
        sb.append("</html>");
        return sb.toString();
    }
}

