/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.stringmapper;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.DSStringUtils;
import com.davidsoergel.dsutils.stringmapper.StringMapper;
import java.lang.reflect.Type;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublePrimitiveArrayMapper
extends StringMapper<double[]> {
    @Override
    public Type[] basicTypes() {
        return new Type[]{double[].class};
    }

    @Override
    public double[] parse(String s) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (String d : s.split(",")) {
            result.add(Double.parseDouble(d));
        }
        return DSArrayUtils.toPrimitive(result.toArray(new Double[0]));
    }

    @Override
    public String render(double[] value) {
        return DSStringUtils.join((Object[])DSArrayUtils.toObject(value), ",");
    }

    @Override
    public String renderHtml(double[] ss) {
        if (ss == null || ss.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer("<html>");
        sb.append("Array of ").append(ss.length).append(" Doubles:<P>");
        if (ss.length <= 20) {
            double[] arr$ = ss;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double s = arr$[i$];
                sb.append(String.format("%g", s)).append("<BR>");
            }
        } else {
            for (int i = 0; i < ss.length; ++i) {
                sb.append(String.format("%g  ", ss[i]));
                if (i % 10 == 0) {
                    sb.append("<br>");
                }
                if (i != 400) continue;
                sb.append("...");
                break;
            }
        }
        sb.append("</html>");
        return sb.toString();
    }
}

