/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.stringmapper;

import com.davidsoergel.dsutils.stringmapper.StringMapper;
import com.davidsoergel.dsutils.stringmapper.StringMapperException;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMapper
extends StringMapper<Class> {
    private static final Logger logger = Logger.getLogger(ClassMapper.class);
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static void setClassLoader(ClassLoader classLoader) {
        ClassMapper.classLoader = classLoader;
    }

    @Override
    public Type[] basicTypes() {
        return new Type[]{Class.class};
    }

    @Override
    public Class parse(String s) throws StringMapperException {
        if (s == null || s.trim().equals("")) {
            throw new StringMapperException("Empty plugin class name");
        }
        try {
            return Class.forName(s, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new StringMapperException(e);
        }
    }

    @Override
    public String render(Class value) {
        return value == null ? "null" : value.getCanonicalName();
    }

    @Override
    public String renderAbbreviated(Class value) {
        return value == null ? "null" : value.getSimpleName();
    }
}

