/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.range.BasicInterval;
import com.davidsoergel.dsutils.range.Interval;
import com.davidsoergel.dsutils.range.MultiIntervalIntersection;
import com.davidsoergel.dsutils.range.MutableBasicInterval;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIntervalUnion<T extends Number>
extends TreeSet<Interval<T>> {
    private static final Logger logger = Logger.getLogger(MultiIntervalIntersection.class);

    public <U extends Interval<T>> MultiIntervalUnion(Set<U> intervalSet) {
        TreeMap fullLeftRightMap = new TreeMap();
        HashSet includedEndpoints = new HashSet();
        for (Interval i : intervalSet) {
            Object left = i.getMin();
            Object right = i.getMax();
            Integer leftCount = (Integer)fullLeftRightMap.get(left);
            Integer rightCount = (Integer)fullLeftRightMap.get(right);
            fullLeftRightMap.put(left, leftCount == null ? 1 : leftCount + 1);
            fullLeftRightMap.put(right, rightCount == null ? -1 : rightCount - 1);
            if (i.isClosedLeft()) {
                includedEndpoints.add(left);
            }
            if (!i.isClosedRight()) continue;
            includedEndpoints.add(right);
        }
        int openParens = 0;
        MutableBasicInterval<Number> currentInterval = null;
        for (Map.Entry entry : fullLeftRightMap.entrySet()) {
            Number position = (Number)entry.getKey();
            Integer parenDelta = (Integer)entry.getValue();
            if (parenDelta != 0) {
                openParens += parenDelta.intValue();
                if (currentInterval == null) {
                    if (openParens <= 0) continue;
                    currentInterval = new MutableBasicInterval<Number>();
                    currentInterval.setLeft(position);
                    currentInterval.setClosedLeft(includedEndpoints.contains(position));
                    continue;
                }
                if (openParens != 0) continue;
                currentInterval.setRight(position);
                currentInterval.setClosedRight(includedEndpoints.contains(position));
                this.add(currentInterval);
                currentInterval = null;
                continue;
            }
            if (includedEndpoints.contains(position)) continue;
            assert (currentInterval != null);
            currentInterval.setRight(position);
            currentInterval.setClosedRight(false);
            this.add(currentInterval);
            currentInterval = new MutableBasicInterval();
            currentInterval.setLeft(position);
            currentInterval.setClosedLeft(false);
        }
        assert (openParens == 0);
    }

    public boolean encompassesValue(T value) {
        try {
            Interval f = this.headSet(new BasicInterval<T>(value, value, false, false)).last();
            return f.encompassesValue(value);
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

