/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.math.MathUtils;
import com.davidsoergel.dsutils.range.BasicSteppedRange;
import com.davidsoergel.dsutils.range.DoubleSetRange;
import com.davidsoergel.dsutils.range.Interval;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleSteppedRange
extends BasicSteppedRange<Double> {
    public DoubleSteppedRange(Double min, Double max, Double step) {
        super(min, max, step);
    }

    protected DoubleSetRange asSetRange() {
        return new DoubleSetRange(this.getValues());
    }

    public int compareTo(Interval<Double> o) {
        return ((Double)this.min).compareTo(o.getMin());
    }

    @Override
    public boolean encompassesValue(Double value) {
        assert (this.step != null);
        assert ((Double)this.step != 0.0);
        Double multiplier = (value - (Double)this.min) / (Double)this.step;
        return MathUtils.equalWithinFPError(multiplier, Math.floor(multiplier));
    }

    @Override
    public SortedSet<Double> getValues() {
        assert (this.step != null);
        assert ((Double)this.step != 0.0);
        TreeSet<Double> result = new TreeSet<Double>();
        for (double d = ((Double)this.min).doubleValue(); d <= (Double)this.max; d += ((Double)this.step).doubleValue()) {
            result.add(d);
        }
        return result;
    }

    @Override
    public int size() {
        assert (this.step != null);
        assert ((Double)this.step != 0.0);
        return (int)(((Double)this.max - (Double)this.min) / (Double)this.step);
    }
}

