/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.dsutils.range.DiscreteRange;
import com.davidsoergel.dsutils.range.SerializableRange;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicSetRange<T extends Serializable>
implements DiscreteRange<T>,
SerializableRange<T> {
    protected SortedSet<T> values = null;

    protected BasicSetRange() {
    }

    protected BasicSetRange(Collection<T> newValues) {
        this.values = new TreeSet<T>();
        this.values.addAll(newValues);
    }

    @Override
    public SortedSet<T> getValues() {
        return this.values;
    }

    public String toString() {
        return "{" + StringUtils.join(this.values.iterator(), ",") + "}";
    }

    public BasicSetRange<T> expandToInclude(T v) {
        HashSet<T> newValues = new HashSet<T>(this.values.size() + 1);
        newValues.addAll(this.values);
        newValues.add(v);
        return this.create(this.values);
    }

    public BasicSetRange<T> expandToInclude(DiscreteRange<T> v) {
        HashSet<T> newValues = new HashSet<T>(this.values.size() + v.size());
        newValues.addAll(this.values);
        newValues.addAll(v.getValues());
        return this.create(this.values);
    }

    protected abstract BasicSetRange<T> create(Collection<T> var1);

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean encompassesValue(T value) {
        return this.values.contains(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicSetRange that = (BasicSetRange)o;
        return DSCollectionUtils.isEqualCollection(this.values, that.values);
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }
}

