/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.math.LongRational;
import com.davidsoergel.dsutils.range.BasicInterval;
import com.davidsoergel.dsutils.range.Interval;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLongRationalInterval
extends BasicInterval<LongRational> {
    private static final Logger logger = Logger.getLogger(BasicLongRationalInterval.class);

    public BasicLongRationalInterval(LongRational left, LongRational right, boolean closedLeft, boolean closedRight) {
        super(left, right, closedLeft, closedRight);
    }

    @Override
    public int compareTo(Interval<LongRational> o) {
        int result = ((LongRational)this.left).compareTo(o.getMin());
        if (result == 0) {
            if (this.closedLeft && !o.isClosedLeft()) {
                result = -1;
            } else if (!this.closedLeft && o.isClosedLeft()) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public boolean encompassesValue(LongRational value) {
        int leftCompare = LongRational.overflowSafeCompare((LongRational)this.left, value);
        int rightCompare = LongRational.overflowSafeCompare((LongRational)this.right, value);
        if (this.closedLeft && leftCompare == 0) {
            return true;
        }
        if (this.closedRight && rightCompare == 0) {
            return true;
        }
        return leftCompare < 0 && rightCompare > 0;
    }
}

